/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.processors.format;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import com.github.fge.jsonschema.library.Dictionary;
import com.github.fge.jsonschema.messages.FormatMessages;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.jsonschema.processors.data.SchemaContext;
import com.github.fge.jsonschema.processors.data.ValidatorList;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.util.NodeType;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;

public final class FormatProcessor
implements Processor<ValidatorList, ValidatorList> {
    private final Map<String, FormatAttribute> attributes;

    public FormatProcessor(Dictionary<FormatAttribute> dict) {
        this.attributes = dict.entries();
    }

    public ValidatorList process(ProcessingReport report, ValidatorList input) throws ProcessingException {
        SchemaContext context = input.getContext();
        JsonNode node = context.getSchema().getNode().get("format");
        if (node == null) {
            return input;
        }
        String fmt = node.textValue();
        FormatAttribute attr = this.attributes.get(fmt);
        if (attr == null) {
            report.warn(input.newMessage().put("domain", "validation").put("keyword", "format").message((Object)FormatMessages.FORMAT_NOT_SUPPORTED).put("attribute", fmt));
            return input;
        }
        NodeType type = context.getInstanceType();
        if (!attr.supportedTypes().contains(type)) {
            return input;
        }
        ArrayList validators = Lists.newArrayList((Iterable)input);
        validators.add(FormatProcessor.formatValidator(attr));
        return new ValidatorList(context, validators);
    }

    private static KeywordValidator formatValidator(final FormatAttribute attr) {
        return new KeywordValidator(){

            @Override
            public void validate(Processor<FullData, ProcessingReport> processor, ProcessingReport report, FullData data) throws ProcessingException {
                attr.validate(report, data);
            }
        };
    }

    public String toString() {
        return "format attribute runner";
    }
}

