/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.examples;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.cfg.ValidationConfiguration;
import com.github.fge.jsonschema.examples.Utils;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.keyword.digest.AbstractDigester;
import com.github.fge.jsonschema.keyword.digest.Digester;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.library.DraftV4Library;
import com.github.fge.jsonschema.library.Keyword;
import com.github.fge.jsonschema.library.Library;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.jsonschema.messages.SyntaxMessages;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.syntax.checkers.AbstractSyntaxChecker;
import com.github.fge.jsonschema.syntax.checkers.SyntaxChecker;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;

public final class Example9 {
    public static void main(String ... args) throws IOException, ProcessingException {
        JsonNode customSchema = Utils.loadResource("/custom-keyword.json");
        JsonNode good = Utils.loadResource("/custom-keyword-good.json");
        JsonNode bad = Utils.loadResource("/custom-keyword-bad.json");
        Keyword keyword = Keyword.newBuilder("divisors").withSyntaxChecker(DivisorsSyntaxChecker.getInstance()).withDigester(DivisorsDigesters.getInstance()).withValidatorClass(DivisorsKeywordValidator.class).freeze();
        Library library = DraftV4Library.get().thaw().addKeyword(keyword).freeze();
        ValidationConfiguration cfg = ValidationConfiguration.newBuilder().setDefaultLibrary("http://my.site/myschema#", library).freeze();
        JsonSchemaFactory factory = JsonSchemaFactory.newBuilder().setValidationConfiguration(cfg).freeze();
        JsonSchema schema = factory.getJsonSchema(customSchema);
        ProcessingReport report = schema.validate(good);
        System.out.println(report);
        report = schema.validate(bad);
        System.out.println(report);
    }

    public static final class DivisorsKeywordValidator
    extends AbstractKeywordValidator {
        private final List<BigInteger> divisors;

        public DivisorsKeywordValidator(JsonNode digest) {
            super("divisors");
            ImmutableList.Builder list = ImmutableList.builder();
            for (JsonNode element : digest) {
                list.add((Object)element.bigIntegerValue());
            }
            this.divisors = list.build();
        }

        @Override
        public void validate(Processor<FullData, FullData> processor, ProcessingReport report, FullData data) throws ProcessingException {
            BigInteger value = data.getInstance().getNode().bigIntegerValue();
            ArrayList failed = Lists.newArrayList();
            for (BigInteger divisor : this.divisors) {
                if (value.mod(divisor).equals(BigInteger.ZERO)) continue;
                failed.add(divisor);
            }
            if (failed.isEmpty()) {
                return;
            }
            report.error(this.newMsg(data).message("integer value is not a multiple of all divisors").put("divisors", this.divisors).put("failed", (Iterable)failed));
        }

        @Override
        public String toString() {
            return "divisors: " + this.divisors;
        }
    }

    private static final class DivisorsDigesters
    extends AbstractDigester {
        private static final Digester INSTANCE = new DivisorsDigesters();
        private static final Comparator<JsonNode> COMPARATOR = new Comparator<JsonNode>(){

            @Override
            public int compare(JsonNode o1, JsonNode o2) {
                return o1.bigIntegerValue().compareTo(o2.bigIntegerValue());
            }
        };

        public static Digester getInstance() {
            return INSTANCE;
        }

        private DivisorsDigesters() {
            super("divisors", NodeType.INTEGER, new NodeType[0]);
        }

        @Override
        public JsonNode digest(JsonNode schema) {
            TreeSet set = Sets.newTreeSet(COMPARATOR);
            for (JsonNode element : schema.get(this.keyword)) {
                set.add(element);
            }
            return FACTORY.arrayNode().addAll((Collection)set);
        }
    }

    private static final class DivisorsSyntaxChecker
    extends AbstractSyntaxChecker {
        private static final SyntaxChecker INSTANCE = new DivisorsSyntaxChecker();

        public static SyntaxChecker getInstance() {
            return INSTANCE;
        }

        private DivisorsSyntaxChecker() {
            super("divisors", NodeType.ARRAY, new NodeType[0]);
        }

        protected void checkValue(Collection<JsonPointer> pointers, ProcessingReport report, SchemaTree tree) throws ProcessingException {
            JsonNode node = this.getNode(tree);
            int size = node.size();
            if (size == 0) {
                report.error(this.newMsg(tree, SyntaxMessages.EMPTY_ARRAY));
                return;
            }
            boolean uniqueItems = true;
            HashSet set = Sets.newHashSet();
            for (int index = 0; index < size; ++index) {
                JsonNode element = node.get(index);
                NodeType type = NodeType.getNodeType((JsonNode)element);
                if (type != NodeType.INTEGER) {
                    report.error(this.newMsg(tree, SyntaxMessages.INCORRECT_ELEMENT_TYPE).put("expected", (Object)NodeType.INTEGER).put("found", (Object)type));
                } else if (element.bigIntegerValue().compareTo(BigInteger.ONE) < 0) {
                    report.error(this.newMsg(tree, SyntaxMessages.INTEGER_IS_NEGATIVE).put("value", element));
                }
                uniqueItems = set.add(element);
            }
            if (!uniqueItems) {
                report.error(this.newMsg(tree, SyntaxMessages.ELEMENTS_NOT_UNIQUE));
            }
        }
    }
}

