/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.format.common;

import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.format.AbstractFormatAttribute;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.messages.FormatMessages;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.joda.time.DateTimeFieldType;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;

public final class DateTimeAttribute
extends AbstractFormatAttribute {
    private static final List<String> FORMATS = ImmutableList.of((Object)"yyyy-MM-dd'T'HH:mm:ssZ", (Object)"yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final DateTimeFormatter FORMATTER;
    private static final FormatAttribute INSTANCE;

    public static FormatAttribute getInstance() {
        return INSTANCE;
    }

    private DateTimeAttribute() {
        super("date-time", NodeType.STRING, new NodeType[0]);
    }

    @Override
    public void validate(ProcessingReport report, FullData data) throws ProcessingException {
        String value = data.getInstance().getNode().textValue();
        try {
            FORMATTER.parseDateTime(value);
        }
        catch (IllegalArgumentException ignored) {
            report.error(this.newMsg(data, FormatMessages.INVALID_DATE_FORMAT).put("expected", FORMATS));
        }
    }

    static {
        DateTimeParser msParser = new DateTimeFormatterBuilder().appendLiteral('.').appendDecimal(DateTimeFieldType.millisOfSecond(), 1, 3).toParser();
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        builder = builder.appendFixedDecimal(DateTimeFieldType.year(), 4).appendLiteral('-').appendFixedDecimal(DateTimeFieldType.monthOfYear(), 2).appendLiteral('-').appendFixedDecimal(DateTimeFieldType.dayOfMonth(), 2).appendLiteral('T').appendFixedDecimal(DateTimeFieldType.hourOfDay(), 2).appendLiteral(':').appendFixedDecimal(DateTimeFieldType.minuteOfHour(), 2).appendLiteral(':').appendFixedDecimal(DateTimeFieldType.secondOfMinute(), 2).appendOptional(msParser).appendTimeZoneOffset("Z", false, 2, 2);
        FORMATTER = builder.toFormatter();
        INSTANCE = new DateTimeAttribute();
    }
}

