/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.library;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.exceptions.unchecked.ValidationConfigurationError;
import com.github.fge.jsonschema.keyword.digest.Digester;
import com.github.fge.jsonschema.keyword.digest.helpers.IdentityDigester;
import com.github.fge.jsonschema.keyword.digest.helpers.SimpleDigester;
import com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import com.github.fge.jsonschema.library.Keyword;
import com.github.fge.jsonschema.messages.ValidationConfigurationMessages;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.syntax.checkers.SyntaxChecker;
import com.github.fge.jsonschema.util.Thawed;
import java.lang.reflect.Constructor;

public final class KeywordBuilder
implements Thawed<Keyword> {
    final String name;
    SyntaxChecker syntaxChecker;
    Digester digester;
    Constructor<? extends KeywordValidator> constructor;

    KeywordBuilder(String name) {
        if (name == null) {
            throw new ValidationConfigurationError(new ProcessingMessage().message((Object)ValidationConfigurationMessages.NULL_NAME));
        }
        this.name = name;
    }

    KeywordBuilder(Keyword keyword) {
        this.name = keyword.name;
        this.syntaxChecker = keyword.syntaxChecker;
        this.digester = keyword.digester;
        this.constructor = keyword.constructor;
    }

    public KeywordBuilder withSyntaxChecker(SyntaxChecker syntaxChecker) {
        if (syntaxChecker == null) {
            throw new ValidationConfigurationError(new ProcessingMessage().message((Object)ValidationConfigurationMessages.NULL_SYNTAX_CHECKER));
        }
        this.syntaxChecker = syntaxChecker;
        return this;
    }

    public KeywordBuilder withDigester(Digester digester) {
        if (digester == null) {
            throw new ValidationConfigurationError(new ProcessingMessage().message((Object)ValidationConfigurationMessages.NULL_DIGESTER));
        }
        this.digester = digester;
        return this;
    }

    public KeywordBuilder withIdentityDigester(NodeType first, NodeType ... other) {
        this.digester = new IdentityDigester(this.name, KeywordBuilder.checkType(first), KeywordBuilder.checkTypes(other));
        return this;
    }

    public KeywordBuilder withSimpleDigester(NodeType first, NodeType ... other) {
        this.digester = new SimpleDigester(this.name, KeywordBuilder.checkType(first), KeywordBuilder.checkTypes(other));
        return this;
    }

    public KeywordBuilder withValidatorClass(Class<? extends KeywordValidator> c) {
        this.constructor = KeywordBuilder.getConstructor(c);
        return this;
    }

    public Keyword freeze() {
        return new Keyword(this);
    }

    private static Constructor<? extends KeywordValidator> getConstructor(Class<? extends KeywordValidator> c) {
        try {
            return c.getConstructor(JsonNode.class);
        }
        catch (NoSuchMethodException ignored) {
            throw new ValidationConfigurationError(new ProcessingMessage().message((Object)ValidationConfigurationMessages.NO_APPROPRIATE_CONSTRUCTOR));
        }
    }

    private static NodeType checkType(NodeType type) {
        if (type == null) {
            throw new ValidationConfigurationError(new ProcessingMessage().message((Object)ValidationConfigurationMessages.NULL_TYPE));
        }
        return type;
    }

    private static NodeType[] checkTypes(NodeType ... types) {
        for (NodeType type : types) {
            if (type != null) continue;
            throw new ValidationConfigurationError(new ProcessingMessage().message((Object)ValidationConfigurationMessages.NULL_TYPE));
        }
        return types;
    }
}

