/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluorumlabs.jext;

import com.github.fluorumlabs.jext.JextUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import java.util.Map;

public abstract class Collector {
    private final StringWriter outBuffer = new StringWriter();
    private final PrintWriter out = new PrintWriter(this.outBuffer);
    private final String title;

    public Collector(String title) {
        this.title = title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String collect() {
        String formattedTitle = String.format("SECTION: %s", this.title);
        String paddedTitle = formattedTitle.replaceAll(".", "=");
        this.out.printf("%s%n%s%n%n", formattedTitle, paddedTitle);
        try {
            this.run();
        }
        catch (Throwable throwable) {
            if (throwable.getMessage() != null) {
                this.out.printf("<<< NO DATA: %s - %s >>>%n", throwable.getClass(), throwable.getMessage());
            } else {
                this.out.printf("<<< NO DATA: %s >>>%n", throwable.getClass());
            }
        }
        finally {
            this.out.println();
        }
        return this.outBuffer.toString();
    }

    public PrintWriter format(String format, Object ... args) {
        return this.out.format(format, args);
    }

    public PrintWriter format(Locale l, String format, Object ... args) {
        return this.out.format(l, format, args);
    }

    public void print(boolean b) {
        this.out.print(b);
    }

    public void print(char c) {
        this.out.print(c);
    }

    public void print(int i) {
        this.out.print(i);
    }

    public void print(long l) {
        this.out.print(l);
    }

    public void print(float f) {
        this.out.print(f);
    }

    public void print(double d) {
        this.out.print(d);
    }

    public void print(char[] s) {
        this.out.print(s);
    }

    public void print(String s) {
        this.out.print(s);
    }

    public void print(Object obj) {
        this.out.print(obj);
    }

    public void printCommandOutput(String ... command) {
        this.out.print(JextUtil.getCommandOutput(command));
    }

    public <K, V> void printMap(Map<K, V> properties) {
        for (Map.Entry<K, V> property : properties.entrySet()) {
            String key = String.valueOf(property.getKey());
            String value = String.valueOf(property.getValue());
            String[] values = value.split(";");
            String keyLower = key.toLowerCase(Locale.US);
            if (keyLower.contains("key") || keyLower.contains("secret") || keyLower.contains("pass") || keyLower.contains("token") || keyLower.contains("license")) {
                for (int i = 0; i < values.length; ++i) {
                    values[i] = JextUtil.redact(values[i]);
                }
            }
            if (values.length > 1) {
                this.out.printf("%s: %s%n", key, values[0]);
                String padding = key.replaceAll(".", " ");
                for (int i = 1; i < values.length; ++i) {
                    this.out.printf("%s  %s%n", padding, values[i]);
                }
                continue;
            }
            this.out.printf("%s: %s%n", key, value);
        }
    }

    public void printf(String format, Object ... args) {
        this.out.printf(format, args);
    }

    public void printf(Locale l, String format, Object ... args) {
        this.out.printf(l, format, args);
    }

    public void println() {
        this.out.println();
    }

    public void println(boolean x) {
        this.out.println(x);
    }

    public void println(char x) {
        this.out.println(x);
    }

    public void println(int x) {
        this.out.println(x);
    }

    public void println(long x) {
        this.out.println(x);
    }

    public void println(float x) {
        this.out.println(x);
    }

    public void println(double x) {
        this.out.println(x);
    }

    public void println(char[] x) {
        this.out.println(x);
    }

    public void println(String x) {
        this.out.println(x);
    }

    public void println(Object x) {
        this.out.println(x);
    }

    protected abstract void run() throws Exception;

    protected Collector() {
        this.title = this.getClass().getSimpleName();
    }
}

