/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluorumlabs.jext;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public final class JextUtil {
    private static boolean UNSAFE = false;

    public static void enableUnsafe() {
        UNSAFE = true;
    }

    public static String redact(String value) {
        if (UNSAFE) {
            return value;
        }
        if (value.length() > 6) {
            return value.substring(0, 3) + "[... REDACTED ...]" + value.substring(value.length() - 3);
        }
        if (value.length() > 3) {
            return value.substring(0, 3) + "[... REDACTED ...]";
        }
        if (value.length() > 1) {
            return value.charAt(0) + "[... REDACTED ...]";
        }
        return "[... REDACTED ...]";
    }

    public static String getCommandOutput(String ... command) {
        StringBuilder sb = new StringBuilder();
        try {
            String s;
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(command);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(proc.getInputStream(), StandardCharsets.UTF_8));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(proc.getErrorStream(), StandardCharsets.UTF_8));
            new Thread(() -> {
                try {
                    proc.waitFor(5000L, TimeUnit.MILLISECONDS);
                    proc.destroyForcibly();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }).start();
            while ((s = stdInput.readLine()) != null) {
                sb.append(s).append("\n");
            }
            while ((s = stdError.readLine()) != null) {
                sb.append("# ERR: ").append(s).append("\n");
            }
        }
        catch (IOException e) {
            if (e.getMessage() != null) {
                sb.append("\n# EXC: ").append(e.getMessage());
            }
            sb.append("\n# EXC: ").append(e.getClass().getSimpleName());
        }
        String result = sb.toString();
        while (!(result.isEmpty() || result.charAt(result.length() - 1) != '\n' && result.charAt(result.length() - 1) != '\r')) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String doGET(String url) {
        try {
            URLConnection connection = new URL(url).openConnection();
            connection.setRequestProperty("Accept-Charset", "UTF-8");
            connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setDoInput(true);
            LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
            for (Map.Entry<String, List<String>> stringListEntry : connection.getHeaderFields().entrySet()) {
                for (String s : stringListEntry.getValue()) {
                    values.put(stringListEntry.getKey(), s);
                }
            }
            try (InputStream response = connection.getInputStream();){
                String string;
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response));){
                    string = bufferedReader.lines().collect(Collectors.joining("\n"));
                }
                return string;
            }
        }
        catch (IOException e) {
            if (e.getMessage() != null) {
                throw new UncheckedIOException(e.getMessage(), e);
            }
            throw new UncheckedIOException(e.getClass().getSimpleName(), e);
        }
    }

    public static Map<String, String> doHEAD(String url) {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod("HEAD");
            connection.setRequestProperty("Accept-Charset", "UTF-8");
            connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
            for (Map.Entry<String, List<String>> stringListEntry : connection.getHeaderFields().entrySet()) {
                for (String s : stringListEntry.getValue()) {
                    values.put(stringListEntry.getKey(), s);
                }
            }
            return values;
        }
        catch (IOException e) {
            if (e.getMessage() != null) {
                throw new UncheckedIOException(e.getMessage(), e);
            }
            throw new UncheckedIOException(e.getClass().getSimpleName(), e);
        }
    }

    public static String getFile(String path) {
        try {
            return String.join((CharSequence)"\n", Files.readAllLines(Paths.get(path, new String[0])));
        }
        catch (IOException e) {
            if (e.getMessage() != null) {
                throw new UncheckedIOException(e.getMessage(), e);
            }
            throw new UncheckedIOException(e.getClass().getSimpleName(), e);
        }
    }

    private JextUtil() {
    }
}

