/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluorumlabs.jext.collect;

import com.github.fluorumlabs.jext.Collector;
import com.github.fluorumlabs.jext.extern.json.JSONObject;
import com.github.fluorumlabs.jext.extern.json.JSONTokener;
import com.github.fluorumlabs.jext.extern.jsoup.Jsoup;
import com.github.fluorumlabs.jext.extern.jsoup.nodes.Document;
import com.github.fluorumlabs.jext.extern.jsoup.nodes.Element;
import com.github.fluorumlabs.jext.extern.jsoup.parser.Parser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;

public class NeighbourProjects
extends Collector {
    @Override
    protected void run() throws Exception {
        Path parent = this.getParentPath(Paths.get("./", new String[0]));
        List directories = Files.list(parent).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toList());
        for (Path directory : directories) {
            String projectName = null;
            if (Files.exists(directory.resolve("pom.xml"), new LinkOption[0])) {
                projectName = this.getMavenPerojectName(directory.resolve("pom.xml"));
            } else if (Files.exists(directory.resolve("package.json"), new LinkOption[0])) {
                projectName = this.getNpmProjectName(directory.resolve("package.json"));
            }
            if (projectName == null) continue;
            this.printf("%s: %s%n", directory, projectName);
        }
    }

    private Path getParentPath(Path current) {
        Path possibleParent = current.resolve("../");
        if (Files.exists(possibleParent.resolve("pom.xml"), new LinkOption[0]) || Files.exists(possibleParent.resolve("package.json"), new LinkOption[0])) {
            return this.getParentPath(possibleParent);
        }
        return possibleParent.toAbsolutePath().normalize();
    }

    private String getMavenPerojectName(Path resolve) {
        try {
            String pomXml = String.join((CharSequence)"\n", Files.readAllLines(resolve));
            Document parsedPom = Jsoup.parse(pomXml, "", Parser.xmlParser());
            Element artifactId = parsedPom.selectFirst("artifactId");
            Element groupId = parsedPom.selectFirst("groupId");
            Element name = parsedPom.selectFirst("name");
            if (groupId != null && artifactId != null) {
                artifactId.text(groupId.text() + ":" + artifactId.text());
            }
            if (artifactId != null) {
                if (name != null) {
                    return "mvn - " + artifactId.text() + " (" + name.text() + ")";
                }
                return "mvn - " + artifactId.text();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private String getNpmProjectName(Path resolve) {
        try {
            String packageJson = String.join((CharSequence)"\n", Files.readAllLines(resolve));
            JSONObject jsonObject = new JSONObject(new JSONTokener(packageJson));
            String projectName = jsonObject.optString("name", null);
            if (projectName != null) {
                return "npm - " + projectName;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

