/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluorumlabs.jext.extern.jsoup.helper;

import com.github.fluorumlabs.jext.extern.jsoup.helper.Validate;
import com.github.fluorumlabs.jext.extern.jsoup.internal.StringUtil;
import com.github.fluorumlabs.jext.extern.jsoup.nodes.Attribute;
import com.github.fluorumlabs.jext.extern.jsoup.nodes.Attributes;
import com.github.fluorumlabs.jext.extern.jsoup.nodes.Comment;
import com.github.fluorumlabs.jext.extern.jsoup.nodes.DataNode;
import com.github.fluorumlabs.jext.extern.jsoup.nodes.Document;
import com.github.fluorumlabs.jext.extern.jsoup.nodes.Node;
import com.github.fluorumlabs.jext.extern.jsoup.nodes.TextNode;
import com.github.fluorumlabs.jext.extern.jsoup.select.NodeTraversor;
import com.github.fluorumlabs.jext.extern.jsoup.select.NodeVisitor;
import com.github.fluorumlabs.jext.extern.w3c.dom.DOMImplementation;
import com.github.fluorumlabs.jext.extern.w3c.dom.DocumentType;
import com.github.fluorumlabs.jext.extern.w3c.dom.Element;
import com.github.fluorumlabs.jext.extern.w3c.dom.Text;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

public class W3CDom {
    protected DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public W3CDom() {
        this.factory.setNamespaceAware(true);
    }

    public static com.github.fluorumlabs.jext.extern.w3c.dom.Document convert(Document in) {
        return new W3CDom().fromJsoup(in);
    }

    public static String asString(com.github.fluorumlabs.jext.extern.w3c.dom.Document doc, Map<String, String> properties) {
        try {
            DOMSource domSource = new DOMSource((com.github.fluorumlabs.jext.extern.w3c.dom.Node)doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            if (properties != null) {
                transformer.setOutputProperties(W3CDom.propertiesFromMap(properties));
            }
            if (doc.getDoctype() != null) {
                DocumentType doctype = doc.getDoctype();
                if (!StringUtil.isBlank(doctype.getPublicId())) {
                    transformer.setOutputProperty("doctype-public", doctype.getPublicId());
                }
                if (!StringUtil.isBlank(doctype.getSystemId())) {
                    transformer.setOutputProperty("doctype-system", doctype.getSystemId());
                } else if (doctype.getName().equalsIgnoreCase("html") && StringUtil.isBlank(doctype.getPublicId()) && StringUtil.isBlank(doctype.getSystemId())) {
                    transformer.setOutputProperty("doctype-system", "about:legacy-compat");
                }
            }
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (TransformerException e) {
            throw new IllegalStateException(e);
        }
    }

    static Properties propertiesFromMap(Map<String, String> map) {
        Properties props = new Properties();
        props.putAll(map);
        return props;
    }

    public static HashMap<String, String> OutputHtml() {
        return W3CDom.methodMap("html");
    }

    public static HashMap<String, String> OutputXml() {
        return W3CDom.methodMap("xml");
    }

    private static HashMap<String, String> methodMap(String method) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("method", method);
        return map;
    }

    public com.github.fluorumlabs.jext.extern.w3c.dom.Document fromJsoup(Document in) {
        Validate.notNull(in);
        try {
            DocumentBuilder builder = this.factory.newDocumentBuilder();
            DOMImplementation impl = builder.getDOMImplementation();
            com.github.fluorumlabs.jext.extern.w3c.dom.Document out = builder.newDocument();
            com.github.fluorumlabs.jext.extern.jsoup.nodes.DocumentType doctype = in.documentType();
            if (doctype != null) {
                DocumentType documentType = impl.createDocumentType(doctype.name(), doctype.publicId(), doctype.systemId());
                out.appendChild((com.github.fluorumlabs.jext.extern.w3c.dom.Node)documentType);
            }
            out.setXmlStandalone(true);
            this.convert(in, out);
            return out;
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    public void convert(Document in, com.github.fluorumlabs.jext.extern.w3c.dom.Document out) {
        if (!StringUtil.isBlank(in.location())) {
            out.setDocumentURI(in.location());
        }
        com.github.fluorumlabs.jext.extern.jsoup.nodes.Element rootEl = in.child(0);
        NodeTraversor.traverse((NodeVisitor)new W3CBuilder(out), rootEl);
    }

    public String asString(com.github.fluorumlabs.jext.extern.w3c.dom.Document doc) {
        return W3CDom.asString(doc, null);
    }

    protected static class W3CBuilder
    implements NodeVisitor {
        private static final String xmlnsKey = "xmlns";
        private static final String xmlnsPrefix = "xmlns:";
        private final com.github.fluorumlabs.jext.extern.w3c.dom.Document doc;
        private final Stack<HashMap<String, String>> namespacesStack = new Stack();
        private Element dest;

        public W3CBuilder(com.github.fluorumlabs.jext.extern.w3c.dom.Document doc) {
            this.doc = doc;
            this.namespacesStack.push(new HashMap());
        }

        @Override
        public void head(Node source, int depth) {
            this.namespacesStack.push(new HashMap(this.namespacesStack.peek()));
            if (source instanceof com.github.fluorumlabs.jext.extern.jsoup.nodes.Element) {
                com.github.fluorumlabs.jext.extern.jsoup.nodes.Element sourceEl = (com.github.fluorumlabs.jext.extern.jsoup.nodes.Element)source;
                String prefix = this.updateNamespaces(sourceEl);
                String namespace = this.namespacesStack.peek().get(prefix);
                String tagName = sourceEl.tagName();
                Element el = namespace == null && tagName.contains(":") ? this.doc.createElementNS("", tagName) : this.doc.createElementNS(namespace, tagName);
                this.copyAttributes(sourceEl, el);
                if (this.dest == null) {
                    this.doc.appendChild((com.github.fluorumlabs.jext.extern.w3c.dom.Node)el);
                } else {
                    this.dest.appendChild((com.github.fluorumlabs.jext.extern.w3c.dom.Node)el);
                }
                this.dest = el;
            } else if (source instanceof TextNode) {
                TextNode sourceText = (TextNode)source;
                Text text = this.doc.createTextNode(sourceText.getWholeText());
                this.dest.appendChild((com.github.fluorumlabs.jext.extern.w3c.dom.Node)text);
            } else if (source instanceof Comment) {
                Comment sourceComment = (Comment)source;
                com.github.fluorumlabs.jext.extern.w3c.dom.Comment comment = this.doc.createComment(sourceComment.getData());
                this.dest.appendChild((com.github.fluorumlabs.jext.extern.w3c.dom.Node)comment);
            } else if (source instanceof DataNode) {
                DataNode sourceData = (DataNode)source;
                Text node = this.doc.createTextNode(sourceData.getWholeData());
                this.dest.appendChild((com.github.fluorumlabs.jext.extern.w3c.dom.Node)node);
            }
        }

        @Override
        public void tail(Node source, int depth) {
            if (source instanceof com.github.fluorumlabs.jext.extern.jsoup.nodes.Element && this.dest.getParentNode() instanceof Element) {
                this.dest = (Element)this.dest.getParentNode();
            }
            this.namespacesStack.pop();
        }

        private void copyAttributes(Node source, Element el) {
            for (Attribute attribute : source.attributes()) {
                String key = attribute.getKey().replaceAll("[^-a-zA-Z0-9_:.]", "");
                if (!key.matches("[a-zA-Z_:][-a-zA-Z0-9_:.]*")) continue;
                el.setAttribute(key, attribute.getValue());
            }
        }

        private String updateNamespaces(com.github.fluorumlabs.jext.extern.jsoup.nodes.Element el) {
            Attributes attributes = el.attributes();
            for (Attribute attr : attributes) {
                String prefix;
                String key = attr.getKey();
                if (key.equals(xmlnsKey)) {
                    prefix = "";
                } else {
                    if (!key.startsWith(xmlnsPrefix)) continue;
                    prefix = key.substring(xmlnsPrefix.length());
                }
                this.namespacesStack.peek().put(prefix, attr.getValue());
            }
            int pos = el.tagName().indexOf(":");
            return pos > 0 ? el.tagName().substring(0, pos) : "";
        }
    }
}

