/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell.interactive;

import com.github.fonimus.ssh.shell.interactive.InteractiveInput;
import com.github.fonimus.ssh.shell.interactive.KeyBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.jline.terminal.Size;

public class Interactive {
    @NonNull
    private InteractiveInput input;
    private long refreshDelay;
    private boolean fullScreen;
    private boolean exit;
    private boolean increase;
    private boolean decrease;
    private List<KeyBinding> bindings;
    private Size size;

    private static long $default$refreshDelay() {
        return 3000L;
    }

    private static boolean $default$fullScreen() {
        return true;
    }

    private static boolean $default$exit() {
        return true;
    }

    private static boolean $default$increase() {
        return true;
    }

    private static boolean $default$decrease() {
        return true;
    }

    Interactive(@NonNull InteractiveInput input, long refreshDelay, boolean fullScreen, boolean exit, boolean increase, boolean decrease, List<KeyBinding> bindings, Size size) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        this.input = input;
        this.refreshDelay = refreshDelay;
        this.fullScreen = fullScreen;
        this.exit = exit;
        this.increase = increase;
        this.decrease = decrease;
        this.bindings = bindings;
        this.size = size;
    }

    public static InteractiveBuilder builder() {
        return new InteractiveBuilder();
    }

    @NonNull
    public InteractiveInput getInput() {
        return this.input;
    }

    public long getRefreshDelay() {
        return this.refreshDelay;
    }

    public boolean isFullScreen() {
        return this.fullScreen;
    }

    public boolean isExit() {
        return this.exit;
    }

    public boolean isIncrease() {
        return this.increase;
    }

    public boolean isDecrease() {
        return this.decrease;
    }

    public List<KeyBinding> getBindings() {
        return this.bindings;
    }

    public Size getSize() {
        return this.size;
    }

    public static class InteractiveBuilder {
        private InteractiveInput input;
        private boolean refreshDelay$set;
        private long refreshDelay$value;
        private boolean fullScreen$set;
        private boolean fullScreen$value;
        private boolean exit$set;
        private boolean exit$value;
        private boolean increase$set;
        private boolean increase$value;
        private boolean decrease$set;
        private boolean decrease$value;
        private ArrayList<KeyBinding> bindings;
        private Size size;

        InteractiveBuilder() {
        }

        public InteractiveBuilder input(@NonNull InteractiveInput input) {
            if (input == null) {
                throw new NullPointerException("input is marked non-null but is null");
            }
            this.input = input;
            return this;
        }

        public InteractiveBuilder refreshDelay(long refreshDelay) {
            this.refreshDelay$value = refreshDelay;
            this.refreshDelay$set = true;
            return this;
        }

        public InteractiveBuilder fullScreen(boolean fullScreen) {
            this.fullScreen$value = fullScreen;
            this.fullScreen$set = true;
            return this;
        }

        public InteractiveBuilder exit(boolean exit) {
            this.exit$value = exit;
            this.exit$set = true;
            return this;
        }

        public InteractiveBuilder increase(boolean increase) {
            this.increase$value = increase;
            this.increase$set = true;
            return this;
        }

        public InteractiveBuilder decrease(boolean decrease) {
            this.decrease$value = decrease;
            this.decrease$set = true;
            return this;
        }

        public InteractiveBuilder binding(KeyBinding binding) {
            if (this.bindings == null) {
                this.bindings = new ArrayList();
            }
            this.bindings.add(binding);
            return this;
        }

        public InteractiveBuilder bindings(Collection<? extends KeyBinding> bindings) {
            if (bindings == null) {
                throw new NullPointerException("bindings cannot be null");
            }
            if (this.bindings == null) {
                this.bindings = new ArrayList();
            }
            this.bindings.addAll(bindings);
            return this;
        }

        public InteractiveBuilder clearBindings() {
            if (this.bindings != null) {
                this.bindings.clear();
            }
            return this;
        }

        public InteractiveBuilder size(Size size) {
            this.size = size;
            return this;
        }

        public Interactive build() {
            List<KeyBinding> bindings;
            switch (this.bindings == null ? 0 : this.bindings.size()) {
                case 0: {
                    bindings = Collections.emptyList();
                    break;
                }
                case 1: {
                    bindings = Collections.singletonList(this.bindings.get(0));
                    break;
                }
                default: {
                    bindings = Collections.unmodifiableList(new ArrayList<KeyBinding>(this.bindings));
                }
            }
            long refreshDelay$value = this.refreshDelay$value;
            if (!this.refreshDelay$set) {
                refreshDelay$value = Interactive.$default$refreshDelay();
            }
            boolean fullScreen$value = this.fullScreen$value;
            if (!this.fullScreen$set) {
                fullScreen$value = Interactive.$default$fullScreen();
            }
            boolean exit$value = this.exit$value;
            if (!this.exit$set) {
                exit$value = Interactive.$default$exit();
            }
            boolean increase$value = this.increase$value;
            if (!this.increase$set) {
                increase$value = Interactive.$default$increase();
            }
            boolean decrease$value = this.decrease$value;
            if (!this.decrease$set) {
                decrease$value = Interactive.$default$decrease();
            }
            return new Interactive(this.input, refreshDelay$value, fullScreen$value, exit$value, increase$value, decrease$value, bindings, this.size);
        }

        public String toString() {
            return "Interactive.InteractiveBuilder(input=" + this.input + ", refreshDelay$value=" + this.refreshDelay$value + ", fullScreen$value=" + this.fullScreen$value + ", exit$value=" + this.exit$value + ", increase$value=" + this.increase$value + ", decrease$value=" + this.decrease$value + ", bindings=" + this.bindings + ", size=" + this.size + ")";
        }
    }
}

