/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell.listeners;

import com.github.fonimus.ssh.shell.listeners.SshShellEvent;
import com.github.fonimus.ssh.shell.listeners.SshShellEventType;
import com.github.fonimus.ssh.shell.listeners.SshShellListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.sshd.server.channel.ChannelSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshShellListenerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SshShellListenerService.class);
    private List<SshShellListener> listeners;

    public SshShellListenerService(List<SshShellListener> listeners) {
        this.listeners = listeners == null ? new ArrayList() : listeners;
        LOGGER.info("Ssh shell listener service initialized with {} listeners", (Object)this.listeners.size());
    }

    public void onSessionStarted(ChannelSession channelSession) {
        this.notify(new SshShellEvent(SshShellEventType.SESSION_STARTED, channelSession));
    }

    public void onSessionStopped(ChannelSession channelSession) {
        this.notify(new SshShellEvent(SshShellEventType.SESSION_STOPPED, channelSession));
    }

    public void onSessionError(ChannelSession channelSession) {
        this.notify(new SshShellEvent(SshShellEventType.SESSION_STOPPED_UNEXPECTEDLY, channelSession));
    }

    private void notify(SshShellEvent event) {
        for (SshShellListener listener : this.listeners) {
            try {
                listener.onEvent(event);
            }
            catch (RuntimeException e) {
                LOGGER.error("Unable to execute onSessionStarted on listener : {}", (Object)listener.getClass().getName(), (Object)e);
            }
        }
    }
}

