/*
 * Decompiled with CFR 0.152.
 */
package com.github.fonimus.ssh.shell.providers;

import com.github.fonimus.ssh.shell.ExtendedCompletionProposal;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.core.MethodParameter;
import org.springframework.shell.CompletionContext;
import org.springframework.shell.CompletionProposal;
import org.springframework.shell.standard.ValueProviderSupport;

public class ExtendedFileValueProvider
extends ValueProviderSupport {
    private boolean replaceAll;

    public ExtendedFileValueProvider(boolean replaceAll) {
        this.replaceAll = replaceAll;
    }

    public boolean supports(MethodParameter parameter, CompletionContext completionContext) {
        if (this.replaceAll) {
            return parameter.getParameterType().equals(File.class);
        }
        return super.supports(parameter, completionContext);
    }

    public List<CompletionProposal> complete(MethodParameter parameter, CompletionContext completionContext, String[] hints) {
        String prefix;
        String input = completionContext.currentWordUpToCursor();
        int lastSlash = input.lastIndexOf("/");
        File currentDir = lastSlash > -1 ? new File(input.substring(0, lastSlash + 1)) : new File("./");
        File[] files = currentDir.listFiles((arg_0, arg_1) -> ExtendedFileValueProvider.lambda$complete$0(prefix = input.substring(lastSlash + 1), arg_0, arg_1));
        if (files == null || files.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.stream(files).map(f -> new ExtendedCompletionProposal(ExtendedFileValueProvider.path(f), f.isFile())).collect(Collectors.toList());
    }

    private static String path(File f) {
        String path = f.getPath().replaceAll("\\\\", "/");
        return f.isDirectory() ? path + "/" : path;
    }

    private static /* synthetic */ boolean lambda$complete$0(String prefix, File dir, String name) {
        return name.startsWith(prefix);
    }
}

