/*
 * Decompiled with CFR 0.152.
 */
package com.github.friendlyjava.jpa.descriptor;

import com.github.friendlyjava.jpa.descriptor.JpaReflectionHelper;
import com.github.friendlyjava.jpa.descriptor.attribute.CommonEntityAttribute;
import com.github.friendlyjava.jpa.descriptor.attribute.ElementCollectionRelationshipEntityAttribute;
import com.github.friendlyjava.jpa.descriptor.attribute.EntityAttribute;
import com.github.friendlyjava.jpa.descriptor.attribute.ManyToManyRelationshipEntityAttribute;
import com.github.friendlyjava.jpa.descriptor.attribute.ManyToOneRelationshipEntityAttribute;
import com.github.friendlyjava.jpa.descriptor.attribute.OneToManyRelationshipEntityAttribute;
import com.github.friendlyjava.jpa.descriptor.attribute.OneToOneRelationshipEntityAttribute;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;

public class JpaDescriptor {
    private static final Map<Class<?>, JpaDescriptor> CACHE = new HashMap();
    private Class<?> jpaClass;
    private boolean isEntity;
    private boolean isEmbeddable;
    private String entityName;
    private Map<String, EntityAttribute> attributes;

    private JpaDescriptor(Class<?> clazz, boolean isEntity, boolean isEmbeddable) {
        this.jpaClass = clazz;
        this.isEntity = isEntity;
        this.isEmbeddable = isEmbeddable;
        if (isEntity) {
            this.entityName = Optional.ofNullable(clazz.getAnnotation(Entity.class)).map(ann -> ann.name()).filter(name -> !name.isEmpty()).orElse(clazz.getSimpleName());
        }
        Map attributes = JpaReflectionHelper.findAllEntityAttributes(clazz).stream().map(attr -> this.toEntityAttribute((Field)attr)).collect(Collectors.toMap(EntityAttribute::getName, Function.identity(), (e1, e2) -> e1, LinkedHashMap::new));
        this.attributes = Collections.unmodifiableMap(attributes);
    }

    public static synchronized JpaDescriptor of(Class<?> clazz) {
        boolean jpaEntity = JpaReflectionHelper.isEntity(clazz);
        boolean jpaEmbeddable = JpaReflectionHelper.isEmbeddable(clazz);
        if (!jpaEntity && !jpaEmbeddable) {
            return null;
        }
        JpaDescriptor metadata = CACHE.get(clazz);
        if (metadata == null) {
            metadata = new JpaDescriptor(clazz, jpaEntity, jpaEmbeddable);
            CACHE.put(clazz, metadata);
        }
        return metadata;
    }

    public static synchronized JpaDescriptor of(Object entity) {
        Objects.requireNonNull(entity, "Can not get descriptor from a null reference");
        return JpaDescriptor.of(entity.getClass());
    }

    private EntityAttribute toEntityAttribute(Field attr) {
        CommonEntityAttribute entityAttribute = new CommonEntityAttribute(attr);
        ManyToMany manyToMany = entityAttribute.getAnnotation(ManyToMany.class);
        if (manyToMany != null) {
            return new ManyToManyRelationshipEntityAttribute(entityAttribute, manyToMany);
        }
        ManyToOne manyToOne = entityAttribute.getAnnotation(ManyToOne.class);
        if (manyToOne != null) {
            return new ManyToOneRelationshipEntityAttribute(entityAttribute, manyToOne);
        }
        OneToMany oneToMany = entityAttribute.getAnnotation(OneToMany.class);
        if (oneToMany != null) {
            return new OneToManyRelationshipEntityAttribute(entityAttribute, oneToMany);
        }
        OneToOne oneToOne = entityAttribute.getAnnotation(OneToOne.class);
        if (oneToOne != null) {
            return new OneToOneRelationshipEntityAttribute(entityAttribute, oneToOne);
        }
        ElementCollection elementCollection = entityAttribute.getAnnotation(ElementCollection.class);
        if (elementCollection != null) {
            return new ElementCollectionRelationshipEntityAttribute(entityAttribute, elementCollection);
        }
        return entityAttribute;
    }

    public Class<?> getJpaClass() {
        return this.jpaClass;
    }

    public boolean isEntity() {
        return this.isEntity;
    }

    public boolean isEmbeddable() {
        return this.isEmbeddable;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public Collection<EntityAttribute> getAttributes() {
        return this.attributes.values();
    }

    public Collection<EntityAttribute> getReadableAttributes() {
        Collection onlyReadable = this.attributes.values().stream().filter(attr -> attr.isGetterPresent()).collect(Collectors.toCollection(LinkedHashSet::new));
        return Collections.unmodifiableCollection(onlyReadable);
    }

    public EntityAttribute getAttribute(String attributeName) {
        return this.attributes.get(attributeName);
    }
}

