/*
 * Decompiled with CFR 0.152.
 */
package com.github.friendlyjava.jpa.descriptor;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.Embeddable;
import javax.persistence.Entity;

public class JpaReflectionHelper {
    private static final String ECLIPSELINK_WEAVING_PREFIX = "_persistence_";
    private static final String ECLIPSELINK_WEAVING_VALUE_HOLDER_SUFFIX = "_vh";
    private static Map<String, Field> ECLIPSELINK_VALUE_HOLDER_CACHE = new HashMap<String, Field>();

    public static boolean isEntity(Object bean) {
        return bean != null && JpaReflectionHelper.isEntity(bean.getClass());
    }

    public static boolean isEntity(Class<?> clazz) {
        return clazz != null && clazz.isAnnotationPresent(Entity.class);
    }

    public static boolean isEmbeddable(Object bean) {
        return bean != null && JpaReflectionHelper.isEmbeddable(bean.getClass());
    }

    public static boolean isEmbeddable(Class<?> clazz) {
        return clazz != null && clazz.isAnnotationPresent(Embeddable.class);
    }

    public static Set<Field> findAllEntityAttributes(Class<?> clazz) {
        LinkedHashSet<Field> allAttributes = new LinkedHashSet<Field>();
        if (!Object.class.equals(clazz.getSuperclass())) {
            allAttributes.addAll(JpaReflectionHelper.findAllEntityAttributes(clazz.getSuperclass()));
        }
        for (Field attr : clazz.getDeclaredFields()) {
            int mod;
            if (attr.getName().startsWith(ECLIPSELINK_WEAVING_PREFIX) || Modifier.isStatic(mod = attr.getModifiers()) || Modifier.isFinal(mod)) continue;
            allAttributes.add(attr);
        }
        return allAttributes;
    }

    public static synchronized Field getEclipseLinkValueHolderField(Class<?> entityClass, String attrName) {
        String CACHE_VALUE_HOLDER_IDENTIFIER = entityClass.getName() + "#" + attrName;
        Field attrValueHolderField = ECLIPSELINK_VALUE_HOLDER_CACHE.get(CACHE_VALUE_HOLDER_IDENTIFIER);
        if (attrValueHolderField == null) {
            try {
                attrValueHolderField = entityClass.getDeclaredField(ECLIPSELINK_WEAVING_PREFIX + attrName + ECLIPSELINK_WEAVING_VALUE_HOLDER_SUFFIX);
                attrValueHolderField.setAccessible(true);
                ECLIPSELINK_VALUE_HOLDER_CACHE.put(CACHE_VALUE_HOLDER_IDENTIFIER, attrValueHolderField);
            }
            catch (NoSuchFieldException | SecurityException e) {
                return null;
            }
        }
        return attrValueHolderField;
    }
}

