/*
 * Decompiled with CFR 0.152.
 */
package com.github.friendlyjava.jpa.descriptor.attribute;

import com.github.friendlyjava.jpa.descriptor.attribute.EntityAttribute;
import com.github.friendlyjava.jpa.descriptor.exception.JpaLoadStateException;
import com.github.friendlyjava.jpa.descriptor.exception.JpaPropertyAccessException;
import com.github.friendlyjava.jpa.descriptor.exception.UnsupportedJpaProviderException;
import com.github.friendlyjava.jpa.descriptor.load.LoadCheckStrategy;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CommonEntityAttribute
implements EntityAttribute {
    private static final Logger LOG = Logger.getLogger(CommonEntityAttribute.class.getName());
    private Field field;
    private Method getter;
    private Method setter;
    private Class<?> type;
    private List<Class<?>> typeParameters;
    private List<Annotation> annotations;

    public CommonEntityAttribute(Field field) {
        this.field = field;
        Type genericType = field.getGenericType();
        ArrayList<Class> typeParameters = new ArrayList<Class>();
        if (genericType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)genericType;
            this.type = (Class)pt.getRawType();
            for (Type t : pt.getActualTypeArguments()) {
                typeParameters.add((Class)t);
            }
        } else if (genericType instanceof Class) {
            this.type = (Class)genericType;
        }
        this.typeParameters = Collections.unmodifiableList(typeParameters);
        Class<?> declaredAt = field.getDeclaringClass();
        String name = this.getName().substring(0, 1).toUpperCase() + this.getName().substring(1);
        try {
            String prefix = field.getType().equals(Boolean.TYPE) ? "is" : "get";
            this.getter = declaredAt.getMethod(prefix + name, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            LOG.log(Level.FINEST, MessageFormat.format("The getter of the \"{0}\" attribute was not found in the declaring class \"{1}\"", this.getName(), declaredAt.getName()));
        }
        try {
            this.setter = declaredAt.getMethod("set" + name, field.getType());
        }
        catch (NoSuchMethodException e) {
            LOG.log(Level.FINEST, MessageFormat.format("The setter of the \"{0}\" attribute was not found in the declaring class \"{1}\"", this.getName(), declaredAt.getName()));
        }
        this.annotations = new ArrayList<Annotation>();
        if (this.isGetterPresent()) {
            for (Annotation ann : this.getter.getAnnotations()) {
                this.annotations.add(ann);
            }
        }
        for (Annotation ann : field.getAnnotations()) {
            this.annotations.add(ann);
        }
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public List<Class<?>> getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    public boolean isLoaded(Object entity) {
        String attributeReference = entity.getClass().getName() + "." + this.getName();
        for (LoadCheckStrategy strategy : LoadCheckStrategy.AVAILABLE_STRATEGIES) {
            if (!strategy.canCheck(entity.getClass())) continue;
            try {
                return strategy.isLoaded(entity, this.getName());
            }
            catch (JpaLoadStateException e) {
                String msg = MessageFormat.format("The strategy \"{0}\" can not check if \"{1}\" has been loaded. Looking for a more suitable strategy...", strategy.getClass().getName(), attributeReference);
                LOG.log(Level.FINEST, msg, e);
            }
        }
        String msg = MessageFormat.format("Can not check if attribute \"{0}\" has been loaded. If you are using a JPA provider that works with byte-code weaving/enhancement, enable this feature!", attributeReference);
        throw new UnsupportedJpaProviderException(msg);
    }

    @Override
    public boolean isGetterPresent() {
        return this.getter != null;
    }

    @Override
    public boolean isSetterPresent() {
        return this.setter != null;
    }

    @Override
    public Object get(Object entity) {
        try {
            return this.getter.invoke(entity, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            String msg = MessageFormat.format("Could not call the getter of the \"{0}\" attribute of the declaring class \"{1}\"", this.getName(), this.getDeclaringClass().getName());
            throw new JpaPropertyAccessException(msg, e);
        }
    }

    @Override
    public void set(Object entity, Object value) {
        try {
            this.setter.invoke(entity, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            String msg = MessageFormat.format("Could not call the setter of the \"{0}\" attribute of the declaring class \"{1}\"", this.getName(), this.getDeclaringClass().getName());
            throw new JpaPropertyAccessException(msg, e);
        }
    }

    @Override
    public List<Annotation> getAnnotations() {
        return Collections.unmodifiableList(this.annotations);
    }

    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        return (T)((Annotation)this.annotations.stream().filter(a -> a.annotationType().equals(clazz)).findFirst().orElse(null));
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> clazz) {
        return this.annotations.stream().anyMatch(a -> a.annotationType().equals(clazz));
    }

    @Override
    public boolean isAnyAnnotationPresent(Class<?> ... classes) {
        return this.annotations.stream().anyMatch(a -> {
            for (Class clazz : classes) {
                if (!a.annotationType().equals(clazz)) continue;
                return true;
            }
            return false;
        });
    }

    public String toString() {
        return MessageFormat.format("{0}.{1} ({2})", this.getDeclaringClass().getName(), this.getName(), this.getType().getName());
    }
}

