/*
 * Decompiled with CFR 0.152.
 */
package com.github.friendlyjava.jpa.descriptor.load;

import com.github.friendlyjava.jpa.descriptor.JpaReflectionHelper;
import com.github.friendlyjava.jpa.descriptor.exception.JpaLoadStateException;
import com.github.friendlyjava.jpa.descriptor.load.LoadCheckStrategy;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import org.eclipse.persistence.indirection.ValueHolderInterface;

public class EclipseLinkLoadCheckStrategy
implements LoadCheckStrategy {
    private Class<?> persistenceObjectInterface;

    @Override
    public boolean isPresent() {
        try {
            this.persistenceObjectInterface = Class.forName("org.eclipse.persistence.internal.descriptors.PersistenceObject");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public boolean canCheck(Class<?> entityClass) {
        return this.persistenceObjectInterface.isAssignableFrom(entityClass);
    }

    @Override
    public boolean isLoaded(Object entity, String attrName) throws JpaLoadStateException {
        try {
            Field persistenceAttrValueHolder = JpaReflectionHelper.getEclipseLinkValueHolderField(entity.getClass(), attrName);
            if (persistenceAttrValueHolder == null) {
                String msg = MessageFormat.format("The ValueHolder of the \"{0}\" attribute was not found in the \"{1}\" class. Make sure this entity has even been provided by EclipseLink!", attrName, entity.getClass().getName());
                throw new JpaLoadStateException(msg);
            }
            ValueHolderInterface propertyVh = (ValueHolderInterface)persistenceAttrValueHolder.get(entity);
            if (propertyVh == null) {
                String msg = MessageFormat.format("The ValueHolder of the class/attribute \"{0}.{1}\" is null. Make sure this entity has even been provided by EclipseLink!", entity.getClass().getName(), attrName);
                throw new JpaLoadStateException(msg);
            }
            return propertyVh.isInstantiated();
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            return true;
        }
    }
}

