/*
 * Decompiled with CFR 0.152.
 */
package math;

import math.Point;

public class Line {
    private double m;
    private double c;

    public Line() {
        this.m = 0.0;
        this.c = 0.0;
    }

    public Line(double m, double c) {
        this.m = m;
        this.c = c;
    }

    public Line(double m, Point p) {
        this.m = m;
        this.c = p.y - m * p.x;
    }

    public Line(double x1, double y1, double x2, double y2) {
        this.m = new Point(x1, y1).findXYGrad(new Point(x2, y2));
        this.c = y1 - this.m * x1;
    }

    public Line(Point p1, Point p2) {
        this.m = p1.findXYGrad(p2);
        this.c = p1.y - this.m * p1.x;
    }

    public void setM(double m) {
        this.m = m;
    }

    public double getM() {
        return this.m;
    }

    public void setC(double c) {
        this.c = c;
    }

    public double getC() {
        return this.c;
    }

    public double getX(double y) {
        return (y - this.c) / this.m;
    }

    public double getY(double x) {
        return this.m * x + this.c;
    }

    public double distance(Point p1, Point p2) {
        double dist = 0.0;
        if (this.passesThroughPoint(p1) && this.passesThroughPoint(p2)) {
            dist = p2.calcDistanceTo(p1);
        }
        return dist;
    }

    public double distanceSquared(Point p1, Point p2) {
        double dist = 0.0;
        if (this.passesThroughPoint(p1) && this.passesThroughPoint(p2)) {
            dist = Math.pow(p2.x - p1.x, 2.0) + Math.pow(p2.y - p1.y, 2.0);
        }
        return dist;
    }

    public boolean intersectsLine(Line line) {
        return !this.isParallelTo(line);
    }

    public boolean isParallelTo(Line line) {
        return this.approxEquals(this.m, line.m);
    }

    public boolean passesThroughPoint(Point p1) {
        return this.approxEquals(p1.y, this.m * p1.x + this.c);
    }

    public Point intersectionWithLine(Line line) {
        double x = -1.0 * (this.c - line.c) / (this.m - line.m);
        double y = this.m * x + this.c;
        return new Point(x, y);
    }

    public void draw(Object g, double x1, double x2) {
    }

    public boolean approxEquals(double val1, double val2) {
        return Math.abs(Math.abs(val1) - Math.abs(val2)) <= 1.0E-14;
    }

    public boolean approxEquals(double val1, double val2, double minDeviation) {
        return Math.abs(Math.abs(val1) - Math.abs(val2)) <= Math.abs(minDeviation);
    }

    public String toString() {
        return "y = " + this.m + "*x + " + this.c;
    }

    public static void main(String[] args) {
        Line ell = new Line(2.0, 4.0, -2.0, -1.0);
        System.out.println(ell.toString());
    }
}

