/*
 * Decompiled with CFR 0.152.
 */
package math.differentialcalculus;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import math.differentialcalculus.CodeGenerator;
import math.differentialcalculus.Differentiable;
import math.differentialcalculus.DifferentiableManager;
import math.differentialcalculus.Formula;
import math.differentialcalculus.Utilities;
import parser.Bracket;
import parser.Number;
import parser.Operator;
import parser.Variable;
import parser.methods.Method;

public class DerivativeStructureBuilder {
    private DifferentiableManager manager = new DifferentiableManager();

    public DerivativeStructureBuilder(String expression) throws Exception {
        try {
            CodeGenerator codeGenerator = new CodeGenerator(expression);
            ArrayList<String> scanner = new ArrayList<String>(codeGenerator.getScanner());
            while (scanner.indexOf(")") != -1) {
                List<String> subList = null;
                try {
                    int closeindex = scanner.indexOf(")");
                    int openindex = Bracket.getComplementIndex(false, closeindex, scanner);
                    subList = scanner.subList(openindex + 1, closeindex);
                    Utilities.print("---subList---before simplification---" + subList);
                    if (!subList.isEmpty()) {
                        List<String> sub;
                        Differentiable diff;
                        List<String> sub2;
                        String op;
                        int i;
                        Differentiable diff2;
                        Formula.simplify(subList);
                        Utilities.print("---subList---after simplification---" + subList);
                        Utilities.print("---handleSingleNumOrVar---" + subList);
                        if (subList.size() == 3 && Operator.isOpeningBracket(subList.get(0)) && Operator.isClosingBracket(subList.get(2)) && !Variable.isVariableString(scanner.get(openindex - 1))) {
                            subList.remove(0);
                            subList.remove(2);
                            diff2 = new Differentiable(this.generateName(), new ArrayList<String>(subList));
                            this.manager.add(diff2);
                            subList.clear();
                            subList.add(diff2.getName());
                        }
                        if (subList.size() == 1 && (Number.isNumber(subList.get(0)) || Variable.isVariableString(subList.get(0)))) {
                            diff2 = new Differentiable(this.generateName(), new ArrayList<String>(subList));
                            this.manager.add(diff2);
                            subList.clear();
                            subList.add(diff2.getName());
                        }
                        for (i = 0; i < subList.size(); ++i) {
                            op = subList.get(i);
                            if (!Operator.isInverse(op) && !Operator.isSquare(op) && !Operator.isCube(op) || i <= 0) continue;
                            sub2 = subList.subList(i - 1, i + 1);
                            diff = new Differentiable(this.generateName(), new ArrayList<String>(sub2));
                            this.manager.add(diff);
                            sub2.clear();
                            sub2.add(diff.getName());
                            --i;
                        }
                        for (i = 0; i < subList.size(); ++i) {
                            op = subList.get(i);
                            if (!Operator.isPower(op) || i <= 0) continue;
                            sub2 = subList.subList(i - 1, i + 2);
                            diff = new Differentiable(this.generateName(), new ArrayList<String>(sub2));
                            this.manager.add(diff);
                            sub2.clear();
                            sub2.add(diff.getName());
                            i -= 2;
                        }
                        for (i = 0; i < subList.size(); ++i) {
                            op = subList.get(i);
                            if (!Operator.isMulOrDiv(op) || i <= 0) continue;
                            sub2 = subList.subList(i - 1, i + 2);
                            diff = new Differentiable(this.generateName(), new ArrayList<String>(sub2));
                            this.manager.add(diff);
                            sub2.clear();
                            sub2.add(diff.getName());
                            i -= 2;
                        }
                        for (i = 0; i < subList.size(); ++i) {
                            op = subList.get(i);
                            if (!Operator.isPlusOrMinus(op) || i <= 0) continue;
                            sub2 = subList.subList(i - 1, i + 2);
                            diff = new Differentiable(this.generateName(), new ArrayList<String>(sub2));
                            this.manager.add(diff);
                            sub2.clear();
                            sub2.add(diff.getName());
                            i -= 2;
                        }
                        if (openindex == 0) {
                            closeindex = scanner.indexOf(")");
                            openindex = Bracket.getComplementIndex(false, closeindex, scanner);
                            List<String> sub3 = scanner.subList(openindex, closeindex + 1);
                            Differentiable diff3 = new Differentiable(this.generateName(), new ArrayList<String>(sub3.subList(1, sub3.size() - 1)));
                            this.manager.add(diff3);
                            sub3.clear();
                            sub3.add(diff3.getName());
                        }
                        if (openindex > 0 && Method.isInBuiltMethod(scanner.get(openindex - 1))) {
                            closeindex = scanner.indexOf(")");
                            openindex = Bracket.getComplementIndex(false, closeindex, scanner);
                            Differentiable diff4 = new Differentiable(this.generateName(), new ArrayList<String>(scanner.subList(openindex - 1, closeindex + 1)));
                            this.manager.add(diff4);
                            sub = scanner.subList(openindex - 1, closeindex + 1);
                            sub.clear();
                            sub.add(diff4.getName());
                            continue;
                        }
                        if (openindex <= 0 || Method.isInBuiltMethod(scanner.get(openindex - 1))) continue;
                        closeindex = scanner.indexOf(")");
                        openindex = Bracket.getComplementIndex(false, closeindex, scanner);
                        Differentiable diff5 = new Differentiable(this.generateName(), new ArrayList<String>(scanner.subList(openindex, closeindex + 1)));
                        this.manager.add(diff5);
                        sub = scanner.subList(openindex, closeindex + 1);
                        sub.clear();
                        sub.add(diff5.getName());
                        continue;
                    }
                    break;
                }
                catch (IndexOutOfBoundsException boundsException) {
                    boundsException.printStackTrace();
                    break;
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(CodeGenerator.class.getName()).log(Level.SEVERE, null, ex);
            throw new Exception("Bad Input!");
        }
    }

    public DifferentiableManager getManager() {
        return this.manager;
    }

    private String generateName() {
        int count = this.manager.count();
        return "myDiff_" + count;
    }

    public static void main(String[] args) {
        try {
            String expression = "3*x/(5-sin(4*x^2-7))+7*x^2";
            DerivativeStructureBuilder derivativeStructureBuilder = new DerivativeStructureBuilder(expression);
        }
        catch (Exception ex) {
            Logger.getLogger(DerivativeStructureBuilder.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

