/*
 * Decompiled with CFR 0.152.
 */
package math.differentialcalculus;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import math.differentialcalculus.Differentiable;
import parser.Number;

public class DifferentiableManager {
    private final ArrayList<Differentiable> DIFFERENTIABLES = new ArrayList();

    public ArrayList<Differentiable> getDIFFERENTIABLES() {
        return new ArrayList<Differentiable>(this.DIFFERENTIABLES);
    }

    public int count() {
        return this.DIFFERENTIABLES.size();
    }

    public boolean contains(String name) {
        return this.indexOf(name) != -1;
    }

    public int indexOf(String name) {
        int sz = this.DIFFERENTIABLES.size();
        for (int i = 0; i < sz; ++i) {
            if (!name.equals(this.DIFFERENTIABLES.get(i).getName())) continue;
            return i;
        }
        return -1;
    }

    public Differentiable getDifferentiable(String name) throws ClassNotFoundException {
        int indexOfnumber = name.indexOf("_") + 1;
        int index = -1;
        if (indexOfnumber != -1) {
            boolean isAutoGenName;
            String numberpart = name.substring(indexOfnumber);
            boolean bl = isAutoGenName = name.startsWith("myDiff_") && Number.isNumber(numberpart);
            if (isAutoGenName) {
                index = Integer.parseInt(numberpart);
            }
        } else {
            index = this.indexOf(name);
        }
        if (index != -1) {
            return this.DIFFERENTIABLES.get(index);
        }
        throw new ClassNotFoundException(" Differentiable " + name + " Does Not Exist.");
    }

    public Differentiable getDifferentiable(int index) throws ClassNotFoundException {
        if (index < this.DIFFERENTIABLES.size() && index >= 0) {
            return this.DIFFERENTIABLES.get(index);
        }
        throw new ClassNotFoundException(" The Index '" + index + "' Does Not Exist.");
    }

    public Differentiable lookUp(String name) {
        try {
            return this.getDifferentiable(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NullPointerException("Differentiable " + name + " does not exist!");
        }
    }

    public void add(Differentiable diff) {
        if (!this.contains(diff.getName())) {
            this.DIFFERENTIABLES.add(diff);
        } else if (this.contains(diff.getName())) {
            this.update(diff.getName(), diff.getData());
        }
    }

    public void delete(String name) {
        int index = this.indexOf(name);
        if (index != -1) {
            this.DIFFERENTIABLES.remove(index);
        }
    }

    public Differentiable firstDifferentiable() {
        int sz = this.DIFFERENTIABLES.size();
        if (sz > 0) {
            return this.DIFFERENTIABLES.get(0);
        }
        throw new NullPointerException("Sorry,No Element Defined Yet!");
    }

    public Differentiable lastDifferentiable() {
        int sz = this.DIFFERENTIABLES.size();
        if (sz > 0) {
            return this.DIFFERENTIABLES.get(sz - 1);
        }
        throw new NullPointerException("Sorry,No Element Defined Yet!");
    }

    public int update(String name, String newName) {
        try {
            Differentiable diff = this.getDifferentiable(name);
            diff.setName(newName);
            int index = this.indexOf(diff.getName());
            this.DIFFERENTIABLES.set(index, diff);
            return index;
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(DifferentiableManager.class.getName()).log(Level.SEVERE, null, ex);
            return -1;
        }
    }

    public int update(String name, ArrayList<String> data) {
        try {
            Differentiable diff = this.getDifferentiable(name);
            diff.setData(data);
            int index = this.indexOf(diff.getName());
            this.DIFFERENTIABLES.set(index, diff);
            return index;
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(DifferentiableManager.class.getName()).log(Level.SEVERE, null, ex);
            return -1;
        }
    }

    public void clearAll() {
        this.DIFFERENTIABLES.clear();
    }
}

