/*
 * Decompiled with CFR 0.152.
 */
package math.matrix.equationParser;

import java.util.ArrayList;
import java.util.List;
import math.matrix.expressParser.Matrix;
import parser.CustomScanner;
import parser.Number;
import parser.Operator;
import parser.STRING;
import parser.Variable;
import util.ErrorLog;
import util.Utils;

public class LinearSystemParser {
    private ErrorLog logger = new ErrorLog();
    private String systemOfEquations = "";
    private ArrayList<String> scanner = new ArrayList();
    private boolean valid = true;
    private int dimension;
    private ArrayList<String> unknowns = new ArrayList();
    private Matrix equationMatrix;
    private String endOfLine = ":";

    public LinearSystemParser(String systemOfEquations) {
        systemOfEquations = systemOfEquations.replace(" ", "");
        systemOfEquations = STRING.purifier(systemOfEquations);
        if (Variable.isVariableString(systemOfEquations.substring(0, 1))) {
            systemOfEquations = "1.0" + systemOfEquations;
        }
        this.systemOfEquations = systemOfEquations;
        this.plusAndMinusStringHandler();
        this.scan();
        this.appendOneToStartOfFreeVariables();
        this.countVariablesAndValidateTheNumberOfEqualsAndSemiColons();
        this.validateChars();
        this.validateVars();
        this.validateNumbers();
        this.validateOperators();
        this.doAritmetic();
        this.buildMatrix();
    }

    public void setEndOfLine(String endOfLine) {
        this.endOfLine = this.isValidEndOfLineChar(endOfLine) ? endOfLine : ",";
    }

    public String getEndOfLine() {
        return this.endOfLine;
    }

    private boolean isValidEndOfLineChar(String eof) {
        return eof.equals(",") || eof.equals(":");
    }

    private void plusAndMinusStringHandler() {
        int size = this.systemOfEquations.length();
        for (int i = 0; i < size; ++i) {
            try {
                if (this.systemOfEquations.substring(i, i + 1).equals("-") && this.systemOfEquations.substring(i + 1, i + 2).equals("+")) {
                    this.systemOfEquations = STRING.replace(this.systemOfEquations, " -", i, i + 2);
                    continue;
                }
                if (this.systemOfEquations.substring(i, i + 1).equals("+") && this.systemOfEquations.substring(i + 1, i + 2).equals("-")) {
                    this.systemOfEquations = STRING.replace(this.systemOfEquations, " -", i, i + 2);
                    continue;
                }
                if (this.systemOfEquations.substring(i, i + 1).equals("+") && this.systemOfEquations.substring(i + 1, i + 2).equals("+")) {
                    this.systemOfEquations = STRING.replace(this.systemOfEquations, " +", i, i + 2);
                    continue;
                }
                if (!this.systemOfEquations.substring(i, i + 1).equals("-") || !this.systemOfEquations.substring(i + 1, i + 2).equals("-")) continue;
                this.systemOfEquations = STRING.replace(this.systemOfEquations, " +", i, i + 2);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public ArrayList<String> getUnknowns() {
        return this.unknowns;
    }

    public Matrix getEquationMatrix() {
        return this.equationMatrix;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setSystemOfEquations(String systemOfEquations) {
        this.systemOfEquations = systemOfEquations;
    }

    public String getSystemOfEquations() {
        return this.systemOfEquations;
    }

    public void setScanner(ArrayList<String> scanner) {
        this.scanner = scanner;
    }

    public ArrayList<String> getScanner() {
        return this.scanner;
    }

    private int indexOfLetter(String input) {
        int sz = input.length();
        for (int i = 0; i < sz; ++i) {
            if (!Character.isLetter(input.substring(i, i + 1).toCharArray()[0])) continue;
            return i;
        }
        return -1;
    }

    private boolean startsWithDigitOrPoint(String input) {
        String st = input.substring(0, 1);
        return STRING.isDigit(st) || st.equals(".");
    }

    private boolean startsWithLetter(String input) {
        String st = input.substring(0, 1);
        return Character.isLetter(st.toCharArray()[0]);
    }

    private void scan() {
        String st;
        int i;
        ArrayList<String> remover = new ArrayList<String>();
        remover.add("");
        CustomScanner cs = new CustomScanner(this.systemOfEquations, true, "*", "+", "-", this.endOfLine, "=");
        this.scanner = (ArrayList)cs.scan();
        for (i = 0; i < this.scanner.size(); ++i) {
            String part2;
            String part12;
            st = this.scanner.get(i);
            int ind = this.indexOfLetter(this.scanner.get(i));
            if (ind == -1) continue;
            if (this.startsWithDigitOrPoint(st)) {
                try {
                    part12 = st.substring(0, ind);
                    part2 = st.substring(ind);
                    this.scanner.set(i, part12);
                    this.scanner.add(i + 1, part2);
                }
                catch (IndexOutOfBoundsException part12) {}
                continue;
            }
            if (!this.startsWithLetter(st) || !st.substring(0, 1).equalsIgnoreCase("E")) continue;
            try {
                part12 = st.substring(0, 1);
                part2 = st.substring(1);
                this.scanner.set(i, part12);
                this.scanner.add(i + 1, part2);
                continue;
            }
            catch (IndexOutOfBoundsException part13) {
                // empty catch block
            }
        }
        this.scanner.removeAll(remover);
        for (i = 0; i < this.scanner.size(); ++i) {
            try {
                st = this.scanner.get(i);
                if (!st.equalsIgnoreCase("E")) continue;
                String st1 = this.scanner.get(i - 1);
                String st2 = this.scanner.get(i + 1);
                String st3 = this.scanner.get(i + 2);
                String st4 = this.scanner.get(i + 3);
                String st5 = this.scanner.get(i + 4);
                if (Number.validNumber(st1) && Operator.isPlusOrMinus(st2) && Number.validNumber(st3) && Variable.isVariableString(st4) && (Operator.isPlusOrMinus(st5) || st5.equals("="))) {
                    st = st1.concat(st);
                    st = st.concat(st2);
                    st = st.concat(st3);
                    this.scanner.set(i - 1, st);
                    this.scanner.subList(i, i + 3).clear();
                    continue;
                }
                if (!Number.validNumber(st1) || !Number.validNumber(st2) || !Variable.isVariableString(st3) || !Operator.isPlusOrMinus(st4) && !st4.equals("=")) continue;
                st = st1.concat(st + "+");
                st = st.concat(st2);
                this.scanner.set(i - 1, st);
                this.scanner.subList(i, i + 2).clear();
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        remover.add("");
        remover.add("(");
        remover.add(")");
        remover.add("*");
        this.scanner.removeAll(remover);
    }

    private void validateChars() {
        for (int i = 0; i < this.scanner.size(); ++i) {
            if (this.scanner.get(i).equals("+") || this.scanner.get(i).equals("-") || this.scanner.get(i).equals("=") || this.scanner.get(i).equals(this.endOfLine) || Number.validNumber(this.scanner.get(i)) || Variable.isVariableString(this.scanner.get(i))) continue;
            this.setValid(false);
            this.scanner.clear();
            break;
        }
    }

    public void appendOneToStartOfFreeVariables() {
        for (int i = 0; i < this.scanner.size(); ++i) {
            try {
                if (!Variable.isVariableString(this.scanner.get(i)) || Number.validNumber(this.scanner.get(i - 1))) continue;
                this.scanner.add(i, "1.0");
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public void countVariablesAndValidateTheNumberOfEqualsAndSemiColons() {
        int numOfVars = 0;
        int numOfSemiColons = 0;
        int numOfEquals = 0;
        ArrayList<String> counter = new ArrayList<String>();
        for (int i = 0; i < this.scanner.size(); ++i) {
            if (Variable.isVariableString(this.scanner.get(i)) && !counter.contains(this.scanner.get(i))) {
                counter.add(this.scanner.get(i));
                ++numOfVars;
                continue;
            }
            if (this.scanner.get(i).equals("=")) {
                ++numOfEquals;
                continue;
            }
            if (!this.scanner.get(i).equals(this.endOfLine)) continue;
            ++numOfSemiColons;
        }
        this.setValid(numOfVars == numOfEquals && numOfEquals == numOfSemiColons);
        if (!this.valid) {
            this.scanner.clear();
        } else {
            this.dimension = numOfEquals;
        }
        this.unknowns.addAll(counter);
    }

    public void validateVars() {
        for (int i = 0; i < this.scanner.size(); ++i) {
            try {
                if (!Variable.isVariableString(this.scanner.get(i))) continue;
                if (!Number.validNumber(this.scanner.get(i - 1))) {
                    this.setValid(false);
                    break;
                }
                if (this.scanner.get(i + 1).equals(this.endOfLine) || this.scanner.get(i + 1).equals("+") || this.scanner.get(i + 1).equals("-") || Operator.isAssignmentOperator(this.scanner.get(i + 1))) continue;
                this.setValid(false);
                break;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public void validateNumbers() {
        for (int i = 0; i < this.scanner.size(); ++i) {
            try {
                if (!Number.validNumber(this.scanner.get(i))) continue;
                if (!(this.scanner.get(i - 1).equals("+") || this.scanner.get(i - 1).equals("-") || this.scanner.get(i - 1).equals("=") || this.scanner.get(i - 1).equals(this.endOfLine))) {
                    this.setValid(false);
                    break;
                }
                if (Variable.isVariableString(this.scanner.get(i + 1)) || Operator.isAssignmentOperator(this.scanner.get(i + 1)) || this.scanner.get(i + 1).equals("+") || this.scanner.get(i + 1).equals("-") || this.scanner.get(i + 1).equals(this.endOfLine)) continue;
                this.setValid(false);
                break;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public void validateOperators() {
        for (int i = 0; i < this.scanner.size(); ++i) {
            try {
                if (Operator.isPlusOrMinus(this.scanner.get(i))) {
                    if (!(Number.validNumber(this.scanner.get(i - 1)) || Variable.isVariableString(this.scanner.get(i - 1)) || Operator.isAssignmentOperator(this.scanner.get(i - 1)) || this.scanner.get(i - 1).equals(this.endOfLine))) {
                        this.setValid(false);
                        break;
                    }
                    if (Number.validNumber(this.scanner.get(i + 1))) continue;
                    this.setValid(false);
                    break;
                }
                if (!this.scanner.get(i).equals(this.endOfLine)) continue;
                if (!Number.validNumber(this.scanner.get(i - 1)) && !Variable.isVariableString(this.scanner.get(i - 1))) {
                    this.setValid(false);
                    break;
                }
                if (Number.validNumber(this.scanner.get(i + 1)) || this.scanner.get(i + 1).equals("+") || this.scanner.get(i + 1).equals("-")) continue;
                this.setValid(false);
                break;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public void doAritmetic() {
        ArrayList<String> scan = new ArrayList<String>();
        int size = this.unknowns.size() * (this.unknowns.size() + 1);
        for (int i = 0; i < size; ++i) {
            scan.add("0");
        }
        int indexer = 0;
        for (int j = 0; j < this.unknowns.size(); ++j) {
            int toIndex = -1;
            try {
                toIndex = this.scanner.indexOf(this.endOfLine);
                if (toIndex == 0) {
                    break;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            List<String> sublist = this.scanner.subList(0, toIndex + 1);
            for (int i = 0; i < sublist.size(); ++i) {
                try {
                    double getValueAtIndex;
                    double entry;
                    if (i > 0) {
                        if (Number.isNumber(sublist.get(i)) && this.unknowns.contains(sublist.get(i + 1))) {
                            int index = this.unknowns.indexOf(sublist.get(i + 1)) + indexer;
                            entry = Double.valueOf(sublist.get(i));
                            getValueAtIndex = Double.valueOf((String)scan.get(index));
                            if (i < sublist.indexOf("=")) {
                                if (sublist.get(i - 1).equals("-")) {
                                    scan.set(index, String.valueOf(getValueAtIndex + -entry));
                                    continue;
                                }
                                if (sublist.get(i - 1).equals("-")) continue;
                                scan.set(index, String.valueOf(getValueAtIndex + entry));
                                continue;
                            }
                            if (i <= sublist.indexOf("=")) continue;
                            if (sublist.get(i - 1).equals("-")) {
                                scan.set(index, String.valueOf(getValueAtIndex - -entry));
                                continue;
                            }
                            if (sublist.get(i - 1).equals("-")) continue;
                            scan.set(index, String.valueOf(getValueAtIndex - entry));
                            continue;
                        }
                        if (!Number.isNumber(sublist.get(i)) || this.unknowns.contains(sublist.get(i + 1))) continue;
                        int index = this.unknowns.size() + indexer;
                        entry = Double.valueOf(sublist.get(i));
                        getValueAtIndex = Double.valueOf((String)scan.get(index));
                        if (i < sublist.indexOf("=")) {
                            if (sublist.get(i - 1).equals("-")) {
                                scan.set(index, String.valueOf(getValueAtIndex - -entry));
                                continue;
                            }
                            if (sublist.get(i - 1).equals("-")) continue;
                            scan.set(index, String.valueOf(getValueAtIndex - entry));
                            continue;
                        }
                        if (i <= sublist.indexOf("=")) continue;
                        if (sublist.get(i - 1).equals("-")) {
                            scan.set(index, String.valueOf(getValueAtIndex + -entry));
                            continue;
                        }
                        if (sublist.get(i - 1).equals("-")) continue;
                        scan.set(index, String.valueOf(getValueAtIndex + entry));
                        continue;
                    }
                    if (i != 0) continue;
                    if (Number.isNumber(sublist.get(i)) && this.unknowns.contains(sublist.get(i + 1))) {
                        int index = this.unknowns.indexOf(sublist.get(i + 1)) + indexer;
                        entry = Double.valueOf(sublist.get(i));
                        getValueAtIndex = Double.valueOf((String)scan.get(index));
                        scan.set(index, String.valueOf(getValueAtIndex + entry));
                        continue;
                    }
                    if (!Number.isNumber(sublist.get(i)) || this.unknowns.contains(sublist.get(i + 1))) continue;
                    int index = this.unknowns.size() + indexer;
                    entry = Double.valueOf(sublist.get(i));
                    getValueAtIndex = Double.valueOf((String)scan.get(index));
                    scan.set(index, String.valueOf(getValueAtIndex - entry));
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            indexer += this.unknowns.size() + 1;
            sublist.clear();
        }
        this.scanner.clear();
        this.scanner.addAll(scan);
    }

    public void buildMatrix() {
        double[][] values = new double[this.dimension][this.dimension + 1];
        int index = 0;
        for (int rows = 0; rows < this.dimension; ++rows) {
            int cols = 0;
            while (cols < this.dimension + 1) {
                values[rows][cols] = Double.valueOf(this.scanner.get(index));
                ++cols;
                ++index;
            }
        }
        this.equationMatrix = new Matrix(values);
    }

    public String interpretedSystem() {
        String system = "";
        int pass = 0;
        int i = 0;
        while (i < this.scanner.size()) {
            if (pass < this.unknowns.size()) {
                system = system + this.scanner.get(i) + this.unknowns.get(pass) + "+";
            } else if (pass == this.unknowns.size()) {
                system = system + "= " + this.scanner.get(i) + ":\n";
                pass = -1;
            }
            ++i;
            ++pass;
        }
        system = system.replace("+-", "-");
        system = system.replace("-+", "-");
        system = system.replace("+=", " =");
        return system;
    }

    public static void main(String[] args) {
        LinearSystemParser parser = new LinearSystemParser("x-9y-7w-4d+9=9w-4d+9:4x-9y+12d-13w=9:-9.0123E-5x+6.02E-8w=12-d-d:13-123x-7y=9:");
        Utils.logError(parser.getEquationMatrix().toString());
        Utils.logError(parser.interpretedSystem());
        Utils.logError(parser.valid + "");
    }
}

