/*
 * Decompiled with CFR 0.152.
 */
package math.matrix.expressParser;

import java.util.ArrayList;
import math.matrix.expressParser.MOperator;

public class MBracket
extends MOperator {
    private String name = "";
    private int index;
    private MBracket complement;
    private boolean evaluated = false;

    public MBracket(String op) {
        super(op);
    }

    public void setEvaluated(boolean evaluated) {
        this.evaluated = evaluated;
    }

    public boolean isEvaluated() {
        return this.evaluated;
    }

    public static MBracket createTwinBracket(MBracket brac) {
        MBracket newBrac = new MBracket(brac.getName());
        newBrac.setComplement(brac.getComplement());
        newBrac.setIndex(brac.getIndex());
        return newBrac;
    }

    public MBracket createTwinBracket() {
        MBracket newBrac = new MBracket(this.getName());
        newBrac.setComplement(this.getComplement());
        newBrac.setIndex(this.getIndex());
        return newBrac;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public MBracket getComplement() {
        return this.complement;
    }

    public void setComplement(MBracket complement) {
        this.complement = complement;
    }

    public boolean isComplement(MBracket brac) {
        return brac == this.getComplement();
    }

    public boolean encloses(MBracket brac) {
        boolean truth = false;
        if (this.getIndex() < brac.getIndex() && this.getComplement().getIndex() > brac.getIndex()) {
            truth = true;
        } else if (this.getIndex() > brac.getIndex() && this.getComplement().getIndex() < brac.getIndex()) {
            truth = true;
        }
        return truth;
    }

    public int getNumberOfInternalBrackets(ArrayList<MBracket> brac) {
        int num = 0;
        for (int i = 0; i < brac.size(); ++i) {
            if (!this.encloses(brac.get(i))) continue;
            ++num;
        }
        return num / 2;
    }

    public static int getComplementIndex(boolean isOpenBracket, int start, ArrayList<String> scan) {
        int open = 0;
        int close = 0;
        int stop = 0;
        if (isOpenBracket) {
            try {
                for (int i = start; i < scan.size(); ++i) {
                    if (scan.get(i).equals("(")) {
                        ++open;
                    } else if (scan.get(i).equals(")")) {
                        ++close;
                    }
                    if (open != close) continue;
                    stop = i;
                }
            }
            catch (IndexOutOfBoundsException i) {}
        } else if (!isOpenBracket) {
            try {
                for (int i = start; i >= 0; --i) {
                    try {
                        if (scan.get(i).equals("(")) {
                            ++open;
                        } else if (scan.get(i).equals(")")) {
                            ++close;
                        }
                        if (open != close) continue;
                        stop = i;
                        break;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return stop;
    }

    public static boolean isOpenBracket(String bracket) {
        return bracket.equals("(");
    }

    public static boolean isCloseBracket(String bracket) {
        return bracket.equals(")");
    }

    public ArrayList<String> getBracketDomainContents(ArrayList<String> scan) {
        if (MBracket.isOpeningBracket(this.getName())) {
            return (ArrayList)scan.subList(this.getIndex(), this.getComplement().getIndex() + 1);
        }
        if (MBracket.isClosingBracket(this.getName())) {
            return (ArrayList)scan.subList(this.getComplement().getIndex(), this.getIndex() + 1);
        }
        return null;
    }
}

