/*
 * Decompiled with CFR 0.152.
 */
package math.matrix.expressParser;

import java.util.ArrayList;
import math.matrix.expressParser.MUnaryPostOperator;
import parser.Operator;
import parser.Precedence;
import parser.UnaryPreOperator;

public class MOperator
extends Operator {
    public static final String ROW_JOIN = "rowJoin";
    public static final String COL_JOIN = "colJoin";
    public static final String TRI_MATRIX = "tri";
    public static final String DET_BRACE = "|";
    public static final String UNIT = "unit";
    public static final String DET = "det";
    public static final String INV = "inv";
    public static final String[] operators = new String[]{"+", "-", "*", "^", "=", "(", ")", ",", "-\u00b9", "\u00b2", "\u00b3", "[", "]", ":", " ", ";", "@"};

    public MOperator(String name) {
        super(name);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static boolean isOperatorString(String op) {
        return op.equals("+") || op.equals("-") || op.equals("*") || op.equals("@") || op.equals("^") || op.equals("=") || op.equals("(") || op.equals(")") || op.equals(ROW_JOIN) || op.equals(COL_JOIN) || op.equals(TRI_MATRIX) || op.equals(DET_BRACE) || op.equals(UNIT) || op.equals(DET) || op.equals(":") || op.equals("-\u00b9") || op.equals(INV) || op.equals("\u00b2") || op.equals("\u00b3") || op.equals(",") || op.equals("[") || op.equals("]");
    }

    public static boolean isRowJoin(String op) {
        return op.equals(ROW_JOIN);
    }

    public static boolean isColJoin(String op) {
        return op.equals(COL_JOIN);
    }

    public static boolean isColon(String op) {
        return op.equals(":");
    }

    public static boolean isTri(String op) {
        return op.equals(TRI_MATRIX);
    }

    public static boolean isUnit(String op) {
        return op.equals(UNIT);
    }

    public static boolean isOpeningBrace(String op) {
        return op.equals("[");
    }

    public static boolean isClosingBrace(String op) {
        return op.equals("]");
    }

    public static boolean isAssignmentOperator(String op) {
        return op.equals("=");
    }

    public static boolean isBinaryOperator(String op) {
        return op.equals("+") || op.equals("-") || op.equals("*") || op.equals("^") || op.equals(ROW_JOIN) || op.equals(COL_JOIN);
    }

    public static boolean isPlusOrMinus(String op) {
        return op.equals("+") || op.equals("-");
    }

    public static boolean isMul(String op) {
        return op.equals("*");
    }

    public static boolean isPower(String op) {
        return op.equals("^");
    }

    public static boolean isBracket(String op) {
        return op.equals("(") || op.equals(")");
    }

    public static boolean isOpeningBracket(String op) {
        return op.equals("(");
    }

    public static boolean isClosingBracket(String op) {
        return op.equals(")");
    }

    public static boolean isInverse(String op) {
        return op.equals("-\u00b9");
    }

    public static boolean isDetHalfSymbol(String op) {
        return op.equals(DET_BRACE);
    }

    public static boolean isDet(String op) {
        return op.equals(DET);
    }

    public static boolean isSquare(String op) {
        return op.equals("\u00b2");
    }

    public static boolean isCube(String op) {
        return op.equals("\u00b3");
    }

    public static boolean isUnaryPreOperator(String op) {
        return op.equals(DET) || op.equals(TRI_MATRIX) || op.equals(UNIT);
    }

    public static boolean isUnaryPostOperator(String op) {
        return op.equals("-\u00b9") || op.equals("\u00b2") || op.equals("\u00b3");
    }

    public static Precedence getPrecedence(String name) {
        if (MOperator.isUnaryPostOperator(name)) {
            return new Precedence(10000);
        }
        if (MOperator.isPower(name)) {
            return new Precedence(9999);
        }
        if (MOperator.isUnaryPreOperator(name)) {
            return new Precedence(9998);
        }
        if (MOperator.isMul(name)) {
            return new Precedence(9997);
        }
        if (MOperator.isPlusOrMinus(name)) {
            return new Precedence(9995);
        }
        return null;
    }

    public static boolean validateAll(ArrayList<String> scan) {
        boolean correct = true;
        for (int i = 0; i < scan.size(); ++i) {
            if (MOperator.isUnaryPostOperator(scan.get(i))) {
                correct = new MUnaryPostOperator(scan.get(i), i, scan).validate(scan);
                continue;
            }
            if (!MOperator.isUnaryPreOperator(scan.get(i))) continue;
            correct = new UnaryPreOperator(scan.get(i), i, scan).validate(scan);
        }
        return correct;
    }
}

