/*
 * Decompiled with CFR 0.152.
 */
package math.matrix.expressParser;

import java.math.BigDecimal;
import java.util.ArrayList;
import math.matrix.expressParser.Matrix;
import math.matrix.expressParser.MmathScanner;
import math.matrix.expressParser.PrecisionMatrix;
import parser.Number;
import parser.Operator;
import parser.STRING;
import util.Dimension;
import util.MatrixFormatException;

public class MatrixValueParser {
    private boolean valid = true;
    private String values = "";
    private ArrayList<String> scan = new ArrayList();
    private Dimension size = new Dimension();

    public MatrixValueParser() {
    }

    public MatrixValueParser(String values) {
        this.values = STRING.purifier(values);
        try {
            this.scanner();
        }
        catch (MatrixFormatException matrixFormatException) {
            // empty catch block
        }
    }

    public void scanner() throws MatrixFormatException {
        block14: {
            try {
                if (!this.values.substring(0, 1).equals("[") || this.values.lastIndexOf("]") != this.values.length() - 1) break block14;
                this.values = this.values.substring(1, this.values.length() - 1);
                if (this.values.contains("[") || this.values.contains("]") || !this.values.substring(this.values.length() - 1, this.values.length()).equals(":")) {
                    this.valid = false;
                    throw new MatrixFormatException("Invalid Matrix Input: " + this.values);
                }
                MmathScanner mathScanner = new MmathScanner(this.values);
                this.scan = mathScanner.scanner();
                for (int i = 0; i < this.scan.size(); ++i) {
                    try {
                        if (!Operator.isPlusOrMinus(this.scan.get(i)) || !Number.validNumber(this.scan.get(i + 1))) continue;
                        this.scan.set(i, this.scan.get(i) + this.scan.get(i + 1));
                        this.scan.set(i + 1, "");
                        continue;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
                ArrayList<String> purify = new ArrayList<String>();
                purify.add("");
                this.scan.removeAll(purify);
                int colonCount = 0;
                for (int i = 0; i < this.scan.size(); ++i) {
                    if (!Operator.isColon(this.scan.get(i))) continue;
                    ++colonCount;
                }
                this.size.width = colonCount;
                ArrayList<String> val = new ArrayList<String>(this.scan);
                int lastColSize = 0;
                int colSize = val.subList(0, val.indexOf(":")).size();
                while (val.size() > 0) {
                    try {
                        lastColSize = colSize;
                        val.subList(0, val.indexOf(":") + 1).clear();
                        colSize = val.subList(0, val.indexOf(":")).size();
                        if (lastColSize == colSize) continue;
                        this.valid = false;
                        break;
                    }
                    catch (IllegalArgumentException ill) {
                        break;
                    }
                    catch (IndexOutOfBoundsException ind) {
                        // empty catch block
                        break;
                    }
                }
                if (!this.valid) break block14;
                this.size.height = this.scan.indexOf(":");
                for (int i = 0; i < this.scan.size(); ++i) {
                    if (!Operator.isColon(this.scan.get(i))) {
                        this.valid = Number.validNumber(this.scan.get(i));
                    }
                    if (this.valid) {
                        continue;
                    }
                    break;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public void setValues(String values) {
        this.values = values;
        try {
            this.scanner();
        }
        catch (MatrixFormatException matrixFormatException) {
            // empty catch block
        }
    }

    public String getValues() {
        return this.values;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
        if (!valid) {
            this.scan.clear();
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setScan(ArrayList<String> scan) {
        this.scan = scan;
    }

    public ArrayList<String> getScan() {
        return this.scan;
    }

    public Matrix getMatrix() throws NullPointerException {
        ArrayList<String> purify = new ArrayList<String>();
        purify.add(":");
        this.scan.removeAll(purify);
        double[][] arr = new double[this.size.width][this.size.height];
        if (this.isValid()) {
            int count = 0;
            for (int rows = 0; rows < this.size.width; ++rows) {
                for (int cols = 0; cols < this.size.height; ++cols) {
                    try {
                        arr[rows][cols] = Double.valueOf(this.scan.get(count));
                        ++count;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        continue;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }
            Matrix output = new Matrix(arr);
            return output;
        }
        return null;
    }

    public PrecisionMatrix getPrecisionMatrix() throws NullPointerException {
        ArrayList<String> purify = new ArrayList<String>();
        purify.add(":");
        this.scan.removeAll(purify);
        BigDecimal[][] arr = new BigDecimal[this.size.width][this.size.height];
        if (this.isValid()) {
            int count = 0;
            for (int rows = 0; rows < this.size.width; ++rows) {
                for (int cols = 0; cols < this.size.height; ++cols) {
                    try {
                        arr[rows][cols] = new BigDecimal(this.scan.get(count));
                        ++count;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        continue;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }
            PrecisionMatrix output = new PrecisionMatrix(arr);
            return output;
        }
        return null;
    }
}

