/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.util.ArrayList;
import java.util.InputMismatchException;
import java.util.List;
import parser.LISTS;
import parser.Number;
import parser.Operator;
import parser.Variable;
import util.SimplePoint;
import util.VariableManager;

public class Bracket
extends Operator {
    private transient String name = "";
    private int index;
    private transient Bracket complement;
    private boolean evaluated = false;

    public Bracket(String op) {
        super(op);
        this.name = op;
    }

    public void setEvaluated(boolean evaluated) {
        this.evaluated = evaluated;
    }

    public boolean isEvaluated() {
        return this.evaluated;
    }

    public static Bracket createTwinBracket(Bracket brac) {
        Bracket newBrac = new Bracket(brac.getName());
        newBrac.setComplement(brac.getComplement());
        newBrac.setIndex(brac.getIndex());
        return newBrac;
    }

    public Bracket createTwinBracket() {
        Bracket newBrac = new Bracket(this.getName());
        newBrac.setComplement(this.getComplement());
        newBrac.setIndex(this.getIndex());
        return newBrac;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public Bracket getComplement() {
        return this.complement;
    }

    public void setComplement(Bracket complement) {
        this.complement = complement;
    }

    public boolean isComplement(Bracket brac) {
        return brac == this.getComplement();
    }

    public boolean encloses(Bracket brac) {
        boolean truth = false;
        if (this.getIndex() < brac.getIndex() && this.getComplement().getIndex() > brac.getIndex()) {
            truth = true;
        } else if (this.getIndex() > brac.getIndex() && this.getComplement().getIndex() < brac.getIndex()) {
            truth = true;
        }
        return truth;
    }

    public int getNumberOfInternalBrackets(ArrayList<Bracket> brac) {
        int num = 0;
        for (int i = 0; i < brac.size(); ++i) {
            if (!this.encloses(brac.get(i))) continue;
            ++num;
        }
        return num / 2;
    }

    public boolean isSBP(ArrayList<String> scan) {
        int i = this.index;
        int j = this.complement.index;
        if (i < j) {
            ++i;
            while (i < j) {
                if (Bracket.isBracket(scan.get(i))) {
                    return false;
                }
                ++i;
            }
        } else if (i > j) {
            ++j;
            while (j < i) {
                if (Bracket.isBracket(scan.get(j))) {
                    return false;
                }
                ++j;
            }
        } else if (i == j) {
            throw new InputMismatchException("Open MBracket Cannot Be On The Same Index As Closing MBracket");
        }
        return true;
    }

    public static int getComplementIndex(boolean isOpenBracket, int start, ArrayList<String> scan) {
        int open = 0;
        int close = 0;
        int stop = 0;
        if (isOpenBracket) {
            try {
                for (int i = start; i < scan.size(); ++i) {
                    if (scan.get(i).equals("(")) {
                        ++open;
                    } else if (scan.get(i).equals(")")) {
                        ++close;
                    }
                    if (open != close) continue;
                    stop = i;
                }
            }
            catch (IndexOutOfBoundsException i) {}
        } else if (!isOpenBracket) {
            try {
                for (int i = start; i >= 0; --i) {
                    try {
                        if (scan.get(i).equals("(")) {
                            ++open;
                        } else if (scan.get(i).equals(")")) {
                            ++close;
                        }
                        if (open != close) continue;
                        stop = i;
                        break;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return stop;
    }

    public static int getComplementIndex(boolean isOpenBracket, int start, List<String> scan) {
        int open = 0;
        int close = 0;
        int stop = 0;
        if (isOpenBracket) {
            try {
                for (int i = start; i < scan.size(); ++i) {
                    if (scan.get(i).equals("(")) {
                        ++open;
                    } else if (scan.get(i).equals(")")) {
                        ++close;
                    }
                    if (open != close) continue;
                    stop = i;
                }
            }
            catch (IndexOutOfBoundsException i) {}
        } else if (!isOpenBracket) {
            try {
                for (int i = start; i >= 0; --i) {
                    try {
                        if (scan.get(i).equals("(")) {
                            ++open;
                        } else if (scan.get(i).equals(")")) {
                            ++close;
                        }
                        if (open != close) continue;
                        stop = i;
                        break;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return stop;
    }

    public static int getComplementIndex(boolean isOpenBracket, int start, String expr) {
        int open = 0;
        int close = 0;
        int stop = 0;
        int size = expr.length();
        if (isOpenBracket) {
            try {
                for (int i = start; i < size; ++i) {
                    if (expr.substring(i, i + 1).equals("(")) {
                        ++open;
                    } else if (expr.substring(i, i + 1).equals(")")) {
                        ++close;
                    }
                    if (open != close) continue;
                    stop = i;
                }
            }
            catch (IndexOutOfBoundsException i) {}
        } else if (!isOpenBracket) {
            try {
                for (int i = start; i >= 0; --i) {
                    try {
                        if (expr.substring(i, i + 1).equals("(")) {
                            ++open;
                        } else if (expr.substring(i, i + 1).equals(")")) {
                            ++close;
                        }
                        if (open != close) continue;
                        stop = i;
                        break;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return stop;
    }

    public static boolean checkBracketStructure(List<String> list, int start, int end) {
        return Bracket.validateBracketStructure(list.subList(start, end + 1));
    }

    public static boolean hasBracketsInRange(List<String> list, int start, int end) {
        int sz = list.size();
        if (start >= 0 && end < sz) {
            for (int i = start; i <= end; ++i) {
                if (!Bracket.isBracket(list.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isOpenBracket(String bracket) {
        return bracket.equals("(");
    }

    public static boolean isCloseBracket(String bracket) {
        return bracket.equals(")");
    }

    public boolean simpleBracketPairHasVariables(ArrayList<String> scan) {
        if (Bracket.isOpenBracket(this.name)) {
            int j = this.complement.index;
            for (int i = this.index; i <= j; ++i) {
                String var = scan.get(i);
                if (!Variable.isVariableString(var)) continue;
                try {
                    Variable v = VariableManager.lookUp(var);
                    return true;
                }
                catch (NullPointerException v) {
                    // empty catch block
                }
            }
        } else {
            int i = this.index;
            for (int j = this.complement.index; j <= i; ++j) {
                String var = scan.get(j);
                if (!Variable.isVariableString(var)) continue;
                try {
                    Variable v = VariableManager.lookUp(var);
                    return true;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public String getDomainContents(ArrayList<String> scan) {
        String contents = "";
        if (Bracket.isOpenBracket(this.name)) {
            int j = this.complement.index;
            for (int i = this.index; i <= j; ++i) {
                contents = contents + scan.get(i);
            }
        } else {
            int i = this.index;
            for (int j = this.complement.index; j <= i; ++j) {
                contents = contents.concat(scan.get(j));
            }
        }
        return contents;
    }

    public List<String> getBracketDomainContents(ArrayList<String> scan) {
        if (Bracket.isOpeningBracket(this.getName())) {
            return scan.subList(this.getIndex(), this.getComplement().getIndex() + 1);
        }
        if (Bracket.isClosingBracket(this.getName())) {
            return scan.subList(this.getComplement().getIndex(), this.getIndex() + 1);
        }
        return null;
    }

    private static boolean validateBracketStructure(List<String> scanner) {
        boolean correctFunction = false;
        ArrayList<String> scan = new ArrayList<String>();
        ArrayList<SimplePoint> map = new ArrayList<SimplePoint>();
        ArrayList<Bracket> bracs = new ArrayList<Bracket>();
        scan.addAll(scanner);
        int open = 0;
        int close = scan.indexOf(")");
        int i = 0;
        while (close != -1) {
            try {
                open = LISTS.prevIndexOf(scan, close, "(");
                map.add(new SimplePoint(open, close));
                Bracket openBrac = new Bracket("(");
                Bracket closeBrac = new Bracket(")");
                openBrac.setIndex(open);
                closeBrac.setIndex(close);
                openBrac.setComplement(closeBrac);
                closeBrac.setComplement(openBrac);
                bracs.add(openBrac);
                bracs.add(closeBrac);
                scan.set(open, "");
                scan.set(close, "");
                close = scan.indexOf(")");
                ++i;
            }
            catch (IndexOutOfBoundsException ind) {
                // empty catch block
                break;
            }
        }
        correctFunction = scan.indexOf("(") == -1 && scan.indexOf(")") == -1;
        return correctFunction;
    }

    public void multiplyContentsByMinusOne(List<String> scanner) {
        List<String> domain = this.getBracketDomainContents((ArrayList)scanner);
        for (int i = 0; i < domain.size(); ++i) {
            if (domain.get(i).equals("+")) {
                domain.set(i, "-");
                continue;
            }
            if (!domain.get(i).equals("-")) continue;
            domain.set(i, "+");
        }
        if (Number.isNumber(domain.get(1))) {
            domain.set(1, "" + -1.0 * Double.parseDouble(domain.get(1)));
        } else if (Variable.isVariableString(domain.get(1))) {
            domain.add(1, "*");
            domain.add(1, "-1");
            this.complement.setIndex(this.complement.index + 2);
        }
    }

    public String domainTokenAt(List<String> scanner, int index) {
        List<String> domain = this.getBracketDomainContents((ArrayList)scanner);
        return domain.get(index);
    }
}

