/*
 * Decompiled with CFR 0.152.
 */
package util;

import parser.STRING;
import parser.Variable;
import util.Utils;

public class Formulae {
    private String expression = "";
    private String variable = "";
    private boolean validFormula = true;
    private String description;

    public Formulae(String expr) {
        this.parseFormulae(expr);
    }

    public String getExpression() {
        return this.expression;
    }

    public void setFormula(String expression) {
        this.expression = expression;
    }

    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public boolean isValidFormula() {
        return this.validFormula;
    }

    public void setValidFormula(boolean validFormula) {
        this.validFormula = validFormula;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return this.variable + "=" + this.expression;
    }

    private void parseFormulae(String formulae) {
        if (!(formulae = STRING.purifier(formulae)).substring(0, 6).equals("store:")) {
            this.setValidFormula(false);
        } else {
            formulae = formulae.substring(6);
            int indexOfEquals = formulae.indexOf("=");
            try {
                String var = formulae.substring(0, indexOfEquals);
                if (Variable.isVariableString(var)) {
                    if (indexOfEquals != -1) {
                        this.variable = var;
                        this.expression = formulae.substring(indexOfEquals + 1);
                    } else {
                        Utils.logError("The formula lacks a dependent variable...\nAn example of a valid formula format is  y=7*x^5.  Formula Format Error");
                        this.setValidFormula(false);
                    }
                } else if (!Variable.isVariableString(var)) {
                    Utils.logError("The formula lacks a dependent variable...\nAn example of a valid formula format is  y=7*x^5.  Formula Format Error");
                    this.setValidFormula(false);
                }
            }
            catch (IndexOutOfBoundsException ind) {
                Utils.logError("Error Occured During Formula Parse:\nCause:\nInvalid Or No Formula Variable used.\nUse The Format When Storing Your Formula:\nFormula Variable = Formula Expression. e.g:y = a*x^6.  Formula Variable Error");
                this.setValidFormula(false);
            }
        }
    }
}

