/*
 * Decompiled with CFR 0.152.
 */
package util;

import interfaces.Savable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import parser.CustomScanner;

public class Serializer {
    public static final String serialize(Savable yourObject) {
        return Serializer.stringifyBytes(Serializer.ser(yourObject));
    }

    public static final Savable deserialize(String encoded) {
        byte[] data = Serializer.getBytes(encoded);
        return (Savable)Serializer.deSer(data);
    }

    public static final byte[] getBytes(String ser) {
        CustomScanner cs = new CustomScanner(ser, false, "[", "]", ",");
        List<String> list = cs.scan();
        byte[] data = new byte[list.size()];
        int i = 0;
        for (String txt : list) {
            data[i] = Byte.valueOf(txt);
            ++i;
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] ser(Savable yourObject) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(bos);
            out.writeObject(yourObject);
            out.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object deSer(byte[] yourBytes) {
        ByteArrayInputStream bis = new ByteArrayInputStream(yourBytes);
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(bis);
            Object object = in.readObject();
            return object;
        }
        catch (Exception e) {
            Object var4_6 = null;
            return var4_6;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static String stringifyBytes(byte[] data) {
        StringBuilder builder = new StringBuilder("[");
        int i = 0;
        int len = data.length;
        for (byte b : data) {
            if (i != len - 1) {
                builder.append(b).append(", ");
            } else {
                builder.append(b).append("]");
            }
            ++i;
        }
        return builder.toString();
    }

    public static void main(String[] args) {
        class Box
        implements Savable {
            String name;
            int len;
            int brd;
            int hei;

            public Box(String name, int len, int brd, int hei) {
                this.name = name;
                this.len = len;
                this.brd = brd;
                this.hei = hei;
            }

            public String getName() {
                return this.name;
            }

            public int getLen() {
                return this.len;
            }

            public int getBrd() {
                return this.brd;
            }

            public int getHei() {
                return this.hei;
            }

            @Override
            public String serialize() {
                return Serializer.serialize(this);
            }

            public String toString() {
                return "box-name=" + this.name + ", dimensions: [len=" + this.len + ", brd=" + this.brd + ", hei=" + this.hei + "]";
            }
        }
        Box bx = new Box("kolo-dollar", 12, 13, 5);
        byte[] data = Serializer.ser(bx);
        Box b = (Box)Serializer.deSer(data);
        System.out.println("reconstructed box is: " + b.toString());
        String bytes = "[23, 44, 78, 233, 56, 91, 90, 22, 23, -92]";
        CustomScanner cs = new CustomScanner(bytes, false, "[", "]", ",");
        List<String> list = cs.scan();
        System.out.println(list);
    }
}

