/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.github.gestalt.config.Gestalt;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.reload.CoreReloadListener;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.Triple;

public class GestaltCache
implements Gestalt,
CoreReloadListener {
    private final Gestalt delegate;
    private final Map<Triple<String, TypeCapture<?>, Tags>, Object> cache = Collections.synchronizedMap(new HashMap());
    private final Tags defaultTags;

    public GestaltCache(Gestalt delegate, Tags defaultTags) {
        this.delegate = delegate;
        this.defaultTags = defaultTags;
    }

    @Override
    public void loadConfigs() throws GestaltException {
        this.delegate.loadConfigs();
        this.cache.clear();
    }

    @Override
    public <T> T getConfig(String path, Class<T> klass) throws GestaltException {
        TypeCapture<T> typeCapture = TypeCapture.of(klass);
        return this.getConfig(path, typeCapture);
    }

    @Override
    public <T> T getConfig(String path, Class<T> klass, Tags tags) throws GestaltException {
        TypeCapture<T> typeCapture = TypeCapture.of(klass);
        return this.getConfig(path, typeCapture, tags);
    }

    @Override
    public <T> T getConfig(String path, TypeCapture<T> klass) throws GestaltException {
        return this.getConfig(path, klass, this.defaultTags);
    }

    @Override
    public <T> T getConfig(String path, TypeCapture<T> klass, Tags tags) throws GestaltException {
        Triple<String, TypeCapture<T>, Tags> key = new Triple<String, TypeCapture<T>, Tags>(path, klass, tags);
        if (this.cache.get(key) != null) {
            return (T)this.cache.get(key);
        }
        T result = this.delegate.getConfig(path, klass, tags);
        this.cache.put(key, result);
        return result;
    }

    @Override
    public <T> T getConfig(String path, T defaultVal, Class<T> klass) {
        TypeCapture<T> typeCapture = TypeCapture.of(klass);
        return this.getConfig(path, defaultVal, typeCapture);
    }

    @Override
    public <T> T getConfig(String path, T defaultVal, Class<T> klass, Tags tags) {
        TypeCapture<T> typeCapture = TypeCapture.of(klass);
        return this.getConfig(path, defaultVal, typeCapture, tags);
    }

    @Override
    public <T> T getConfig(String path, T defaultVal, TypeCapture<T> klass) {
        return this.getConfig(path, defaultVal, klass, this.defaultTags);
    }

    @Override
    public <T> T getConfig(String path, T defaultVal, TypeCapture<T> klass, Tags tags) {
        Triple<String, TypeCapture<T>, Tags> key = new Triple<String, TypeCapture<T>, Tags>(path, klass, tags);
        if (this.cache.containsKey(key)) {
            Object result = this.cache.get(key);
            if (result == null) {
                result = defaultVal;
            }
            return (T)result;
        }
        Optional<Object> resultOptional = this.delegate.getConfigOptional(path, klass, tags);
        T result = resultOptional.orElse(null);
        this.cache.put(key, result);
        if (result != null) {
            return result;
        }
        return defaultVal;
    }

    @Override
    public <T> Optional<T> getConfigOptional(String path, Class<T> klass) {
        TypeCapture<T> typeCapture = TypeCapture.of(klass);
        return this.getConfigOptional(path, typeCapture);
    }

    @Override
    public <T> Optional<T> getConfigOptional(String path, Class<T> klass, Tags tags) {
        TypeCapture<T> typeCapture = TypeCapture.of(klass);
        return this.getConfigOptional(path, typeCapture, tags);
    }

    @Override
    public <T> Optional<T> getConfigOptional(String path, TypeCapture<T> klass) {
        return this.getConfigOptional(path, klass, this.defaultTags);
    }

    @Override
    public <T> Optional<T> getConfigOptional(String path, TypeCapture<T> klass, Tags tags) {
        Triple<String, TypeCapture<T>, Tags> key = new Triple<String, TypeCapture<T>, Tags>(path, klass, tags);
        if (this.cache.containsKey(key)) {
            Object result = this.cache.get(key);
            return Optional.ofNullable(result);
        }
        Optional<Object> resultOptional = this.delegate.getConfigOptional(path, klass, tags);
        Object result = resultOptional.orElse(null);
        this.cache.put(key, result);
        return Optional.ofNullable(result);
    }

    @Override
    public void registerListener(CoreReloadListener listener) {
        this.delegate.registerListener(listener);
    }

    @Override
    public void removeListener(CoreReloadListener listener) {
        this.delegate.removeListener(listener);
    }

    @Override
    public void reload() {
        this.cache.clear();
    }
}

