/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.github.gestalt.config.Gestalt;
import org.github.gestalt.config.annotations.ConfigPrefix;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.decoder.DecoderService;
import org.github.gestalt.config.entity.ConfigNodeContainer;
import org.github.gestalt.config.entity.GestaltConfig;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.entity.ValidationLevel;
import org.github.gestalt.config.exceptions.GestaltConfigurationException;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.lexer.SentenceLexer;
import org.github.gestalt.config.loader.ConfigLoader;
import org.github.gestalt.config.loader.ConfigLoaderService;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.ConfigNodeService;
import org.github.gestalt.config.post.process.PostProcessor;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.reload.ConfigReloadListener;
import org.github.gestalt.config.reload.CoreReloadListener;
import org.github.gestalt.config.reload.CoreReloadListenersContainer;
import org.github.gestalt.config.source.ConfigSource;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.token.Token;
import org.github.gestalt.config.utils.ErrorsUtil;
import org.github.gestalt.config.utils.Pair;
import org.github.gestalt.config.utils.ValidateOf;

public class GestaltCore
implements Gestalt,
ConfigReloadListener {
    private static final System.Logger logger = System.getLogger(GestaltCore.class.getName());
    private final ConfigLoaderService configLoaderService;
    private final List<ConfigSource> sources;
    private final DecoderService decoderService;
    private final SentenceLexer sentenceLexer;
    private final GestaltConfig gestaltConfig;
    private final ConfigNodeService configNodeService;
    private final CoreReloadListenersContainer coreReloadListenersContainer;
    private final List<PostProcessor> postProcessors;
    private final List<ValidationError> loadErrors = new ArrayList<ValidationError>();
    private final Tags defaultTags;
    private final DecoderContext decoderContext;

    public GestaltCore(ConfigLoaderService configLoaderService, List<ConfigSource> sources, DecoderService decoderService, SentenceLexer sentenceLexer, GestaltConfig gestaltConfig, ConfigNodeService configNodeService, CoreReloadListenersContainer reloadStrategy, List<PostProcessor> postProcessor, Tags defaultTags) {
        this.configLoaderService = configLoaderService;
        this.sources = sources;
        this.decoderService = decoderService;
        this.sentenceLexer = sentenceLexer;
        this.gestaltConfig = gestaltConfig;
        this.configNodeService = configNodeService;
        this.coreReloadListenersContainer = reloadStrategy;
        this.postProcessors = postProcessor != null ? postProcessor : Collections.emptyList();
        this.defaultTags = defaultTags;
        this.decoderContext = new DecoderContext(decoderService, this);
    }

    List<ValidationError> getLoadErrors() {
        return this.loadErrors;
    }

    public DecoderService getDecoderService() {
        return this.decoderService;
    }

    @Override
    public void registerListener(CoreReloadListener listener) {
        this.coreReloadListenersContainer.registerListener(listener);
    }

    @Override
    public void removeListener(CoreReloadListener listener) {
        this.coreReloadListenersContainer.removeListener(listener);
    }

    @Override
    public void loadConfigs() throws GestaltException {
        if (this.sources == null || this.sources.isEmpty()) {
            throw new GestaltException("No sources provided, unable to load any configs");
        }
        for (ConfigSource source : this.sources) {
            ConfigLoader configLoader = this.configLoaderService.getLoader(source.format());
            ValidateOf<List<ConfigNodeContainer>> newNode = configLoader.loadSource(source);
            this.validateLoadResultsForErrors(newNode, source);
            if (newNode.hasResults()) {
                for (ConfigNodeContainer node : newNode.results()) {
                    ValidateOf<ConfigNode> mergedNode = this.configNodeService.addNode(node);
                    this.validateLoadResultsForErrors(mergedNode, source);
                    this.loadErrors.addAll(mergedNode.getErrors());
                }
                continue;
            }
            logger.log(System.Logger.Level.WARNING, "Failed to load node: {0} did not have any results", source.name());
        }
        this.postProcessConfigs();
    }

    @Override
    public void reload(ConfigSource reloadSource) throws GestaltException {
        if (reloadSource == null) {
            throw new GestaltException("No sources provided, unable to reload any configs");
        }
        if (this.sources == null || this.sources.isEmpty()) {
            throw new GestaltException("No sources provided, unable to reload any configs");
        }
        if (!this.sources.contains(reloadSource)) {
            throw new GestaltException("Can not reload a source that does not exist.");
        }
        ConfigLoader configLoader = this.configLoaderService.getLoader(reloadSource.format());
        ValidateOf<List<ConfigNodeContainer>> reloadNodes = configLoader.loadSource(reloadSource);
        this.validateLoadResultsForErrors(reloadNodes, reloadSource);
        if (!reloadNodes.hasResults()) {
            throw new GestaltException("no results found reloading source " + reloadSource.name());
        }
        for (ConfigNodeContainer reloadNode : reloadNodes.results()) {
            ValidateOf<ConfigNode> mergedNode = this.configNodeService.reloadNode(reloadNode);
            this.validateLoadResultsForErrors(mergedNode, reloadSource);
            if (!mergedNode.hasResults()) {
                throw new GestaltException("no results found merging source " + reloadSource.name());
            }
            this.postProcessConfigs();
        }
        this.coreReloadListenersContainer.reload();
    }

    void postProcessConfigs() throws GestaltException {
        ValidateOf<Boolean> results = this.configNodeService.postProcess(this.postProcessors);
        if (this.checkErrorsShouldFail(results)) {
            throw new GestaltException("Failed post processing config nodes with errors ", results.getErrors());
        }
        if (results.hasErrors().booleanValue() && logger.isLoggable(System.Logger.Level.DEBUG)) {
            String errorMsg = ErrorsUtil.buildErrorMessage("Failed post processing config nodes with errors ", results.getErrors());
            logger.log(System.Logger.Level.DEBUG, errorMsg);
        }
        if (!results.hasResults()) {
            throw new GestaltException("no results found post processing the config nodes");
        }
        if (!results.results().booleanValue()) {
            throw new GestaltException("Post processing failed");
        }
    }

    private void validateLoadResultsForErrors(ValidateOf<?> results, ConfigSource source) throws GestaltConfigurationException {
        if (this.gestaltConfig.isTreatWarningsAsErrors() && results.hasErrors().booleanValue() || results.hasErrors(ValidationLevel.ERROR).booleanValue() && source.failOnErrors()) {
            throw new GestaltConfigurationException("Failed to load configs from source: " + source.name(), results.getErrors());
        }
        if (results.hasErrors(ValidationLevel.WARN).booleanValue() && logger.isLoggable(System.Logger.Level.WARNING)) {
            String errorMsg = ErrorsUtil.buildErrorMessage(results.getErrors());
            logger.log(System.Logger.Level.WARNING, errorMsg);
        }
        if (!results.hasResults()) {
            throw new GestaltConfigurationException("No results found for node");
        }
    }

    private <T> String buildPathWithConfigPrefix(TypeCapture<T> klass, String path) {
        ConfigPrefix[] prefix;
        StringBuilder combinedPath = new StringBuilder(path);
        for (ConfigPrefix configPrefix : prefix = (ConfigPrefix[])klass.getAnnotationsByType(ConfigPrefix.class)) {
            if (combinedPath.length() > 0) {
                combinedPath.append(this.sentenceLexer.getDeliminator());
            }
            combinedPath.append(configPrefix.prefix());
        }
        return combinedPath.toString();
    }

    @Override
    public <T> T getConfig(String path, Class<T> klass) throws GestaltException {
        Objects.requireNonNull(klass);
        return this.getConfig(path, TypeCapture.of(klass));
    }

    @Override
    public <T> T getConfig(String path, Class<T> klass, Tags tags) throws GestaltException {
        Objects.requireNonNull(klass);
        return this.getConfig(path, TypeCapture.of(klass), tags);
    }

    @Override
    public <T> T getConfig(String path, TypeCapture<T> klass) throws GestaltException {
        return this.getConfig(path, klass, this.defaultTags);
    }

    @Override
    public <T> T getConfig(String path, TypeCapture<T> klass, Tags tags) throws GestaltException {
        Objects.requireNonNull(path);
        Objects.requireNonNull(klass);
        Objects.requireNonNull(tags);
        Pair<Boolean, T> isOptionalAndDefault = this.isOptionalAndDefault(klass);
        return this.getConfigInternal(path, isOptionalAndDefault.getFirst() == false, isOptionalAndDefault.getSecond(), klass, tags);
    }

    @Override
    public <T> T getConfig(String path, T defaultVal, Class<T> klass) {
        Objects.requireNonNull(klass);
        return this.getConfig(path, defaultVal, TypeCapture.of(klass));
    }

    @Override
    public <T> T getConfig(String path, T defaultVal, Class<T> klass, Tags tags) {
        Objects.requireNonNull(klass);
        return this.getConfig(path, defaultVal, TypeCapture.of(klass), tags);
    }

    @Override
    public <T> T getConfig(String path, T defaultVal, TypeCapture<T> klass) {
        return this.getConfig(path, defaultVal, klass, this.defaultTags);
    }

    @Override
    public <T> T getConfig(String path, T defaultVal, TypeCapture<T> klass, Tags tags) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(defaultVal);
        Objects.requireNonNull(klass);
        Objects.requireNonNull(tags);
        try {
            return this.getConfigInternal(path, false, defaultVal, klass, tags);
        }
        catch (GestaltException e) {
            logger.log(System.Logger.Level.WARNING, e.getMessage());
            return defaultVal;
        }
    }

    @Override
    public <T> Optional<T> getConfigOptional(String path, Class<T> klass) {
        Objects.requireNonNull(klass);
        return this.getConfigOptional(path, TypeCapture.of(klass));
    }

    @Override
    public <T> Optional<T> getConfigOptional(String path, Class<T> klass, Tags tags) {
        Objects.requireNonNull(klass);
        return this.getConfigOptional(path, TypeCapture.of(klass), tags);
    }

    @Override
    public <T> Optional<T> getConfigOptional(String path, TypeCapture<T> klass) {
        Objects.requireNonNull(klass);
        return this.getConfigOptional(path, klass, this.defaultTags);
    }

    @Override
    public <T> Optional<T> getConfigOptional(String path, TypeCapture<T> klass, Tags tags) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(klass);
        Objects.requireNonNull(tags);
        try {
            Object results = this.getConfigInternal(path, false, null, klass, tags);
            return Optional.ofNullable(results);
        }
        catch (GestaltException e) {
            logger.log(System.Logger.Level.WARNING, e.getMessage());
            return Optional.empty();
        }
    }

    private <T> T getConfigInternal(String path, boolean failOnErrors, T defaultVal, TypeCapture<T> klass, Tags tags) throws GestaltException {
        Objects.requireNonNull(path);
        Objects.requireNonNull(klass);
        Objects.requireNonNull(tags);
        String combinedPath = this.buildPathWithConfigPrefix(klass, path);
        ValidateOf<List<Token>> tokens = this.sentenceLexer.scan(combinedPath);
        if (tokens.hasErrors().booleanValue()) {
            throw new GestaltException("Unable to parse path: " + combinedPath, tokens.getErrors());
        }
        ValidateOf<T> results = this.getConfigInternal(combinedPath, tokens.results(), klass, tags);
        if (this.checkErrorsShouldFail(results)) {
            if (failOnErrors) {
                throw new GestaltException("Failed getting config path: " + combinedPath + ", for class: " + klass.getName(), results.getErrors());
            }
            if (logger.isLoggable(this.gestaltConfig.getLogLevelForMissingValuesWhenDefaultOrOptional())) {
                String errorMsg = ErrorsUtil.buildErrorMessage("Failed getting config path: " + combinedPath + ", for class: " + klass.getName() + " returning empty Optional", results.getErrors());
                logger.log(this.gestaltConfig.getLogLevelForMissingValuesWhenDefaultOrOptional(), errorMsg);
            }
            return defaultVal;
        }
        if (results.hasErrors().booleanValue() && logger.isLoggable(System.Logger.Level.DEBUG)) {
            String errorMsg = ErrorsUtil.buildErrorMessage("Errors getting config path: " + combinedPath + ", for class: " + klass.getName(), results.getErrors());
            logger.log(System.Logger.Level.DEBUG, errorMsg);
        }
        if (results.hasResults()) {
            return results.results();
        }
        if (logger.isLoggable(this.gestaltConfig.getLogLevelForMissingValuesWhenDefaultOrOptional())) {
            String errorMsg = ErrorsUtil.buildErrorMessage("No results for Optional config path: " + combinedPath + ", and class: " + klass.getName() + " returning empty Optional", tokens.getErrors());
            logger.log(this.gestaltConfig.getLogLevelForMissingValuesWhenDefaultOrOptional(), errorMsg);
        }
        if (failOnErrors) {
            throw new GestaltException("No results for config path: " + combinedPath + ", and class: " + klass.getName());
        }
        return defaultVal;
    }

    private <T> ValidateOf<T> getConfigInternal(String path, List<Token> tokens, TypeCapture<T> klass, Tags tags) {
        ValidateOf<ConfigNode> node = this.configNodeService.navigateToNode(path, tokens, tags);
        if (!node.hasErrors().booleanValue() || node.hasErrors(ValidationLevel.MISSING_VALUE).booleanValue()) {
            ValidateOf<T> decodedResults = this.decoderService.decodeNode(path, tags, node.results(), klass, this.decoderContext);
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            if (!decodedResults.hasResults() && node.hasErrors(ValidationLevel.MISSING_VALUE).booleanValue()) {
                errors.addAll(node.getErrors());
            } else {
                errors.addAll(node.getErrors());
                errors.addAll(decodedResults.getErrors());
            }
            return ValidateOf.validateOf(decodedResults.results(), errors);
        }
        return ValidateOf.inValid(node.getErrors());
    }

    private <T> boolean checkErrorsShouldFail(ValidateOf<T> results) {
        if (results.hasErrors().booleanValue()) {
            return !results.getErrors().stream().allMatch(this::ignoreError) || !results.hasResults();
        }
        return false;
    }

    private boolean ignoreError(ValidationError error) {
        if (this.gestaltConfig.isTreatWarningsAsErrors()) {
            return false;
        }
        if (error instanceof ValidationError.ArrayMissingIndex && !this.gestaltConfig.isTreatMissingArrayIndexAsError()) {
            return true;
        }
        if (error.hasNoResults() && !this.gestaltConfig.isTreatMissingValuesAsErrors()) {
            return true;
        }
        if (error instanceof ValidationError.NullValueDecodingObject && !this.gestaltConfig.isTreatNullValuesInClassAsErrors()) {
            return true;
        }
        return error.level() != ValidationLevel.ERROR && error.level() != ValidationLevel.MISSING_VALUE;
    }

    private <T> Pair<Boolean, T> isOptionalAndDefault(TypeCapture<T> klass) {
        if (Optional.class.isAssignableFrom(klass.getRawType())) {
            return new Pair(true, Optional.empty());
        }
        if (OptionalInt.class.isAssignableFrom(klass.getRawType())) {
            return new Pair<Boolean, OptionalInt>(true, OptionalInt.empty());
        }
        if (OptionalLong.class.isAssignableFrom(klass.getRawType())) {
            return new Pair<Boolean, OptionalLong>(true, OptionalLong.empty());
        }
        if (OptionalDouble.class.isAssignableFrom(klass.getRawType())) {
            return new Pair<Boolean, OptionalDouble>(true, OptionalDouble.empty());
        }
        return new Pair<Boolean, Object>(false, null);
    }
}

