/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.builder;

import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.github.gestalt.config.Gestalt;
import org.github.gestalt.config.GestaltCache;
import org.github.gestalt.config.GestaltCore;
import org.github.gestalt.config.decoder.Decoder;
import org.github.gestalt.config.decoder.DecoderRegistry;
import org.github.gestalt.config.decoder.DecoderService;
import org.github.gestalt.config.decoder.ProxyDecoderMode;
import org.github.gestalt.config.entity.GestaltConfig;
import org.github.gestalt.config.entity.GestaltModuleConfig;
import org.github.gestalt.config.exceptions.GestaltConfigurationException;
import org.github.gestalt.config.lexer.PathLexer;
import org.github.gestalt.config.lexer.SentenceLexer;
import org.github.gestalt.config.loader.ConfigLoader;
import org.github.gestalt.config.loader.ConfigLoaderRegistry;
import org.github.gestalt.config.loader.ConfigLoaderService;
import org.github.gestalt.config.node.ConfigNodeManager;
import org.github.gestalt.config.node.ConfigNodeService;
import org.github.gestalt.config.path.mapper.PathMapper;
import org.github.gestalt.config.post.process.PostProcessor;
import org.github.gestalt.config.post.process.PostProcessorConfig;
import org.github.gestalt.config.reload.ConfigReloadStrategy;
import org.github.gestalt.config.reload.CoreReloadListener;
import org.github.gestalt.config.reload.CoreReloadListenersContainer;
import org.github.gestalt.config.source.ConfigSource;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.CollectionUtils;

public class GestaltBuilder {
    private static final System.Logger logger = System.getLogger(GestaltBuilder.class.getName());
    private final List<ConfigReloadStrategy> reloadStrategies = new ArrayList<ConfigReloadStrategy>();
    private final List<CoreReloadListener> coreCoreReloadListeners = new ArrayList<CoreReloadListener>();
    private final Map<Class, GestaltModuleConfig> modules = new HashMap<Class, GestaltModuleConfig>();
    private ConfigLoaderService configLoaderService = new ConfigLoaderRegistry();
    private DecoderService decoderService;
    private SentenceLexer sentenceLexer = new PathLexer();
    private GestaltConfig gestaltConfig = new GestaltConfig();
    private ConfigNodeService configNodeService = new ConfigNodeManager();
    private List<ConfigSource> sources = new ArrayList<ConfigSource>();
    private List<Decoder<?>> decoders = new ArrayList();
    private List<ConfigLoader> configLoaders = new ArrayList<ConfigLoader>();
    private List<PostProcessor> postProcessors = new ArrayList<PostProcessor>();
    private List<PathMapper> pathMappers = new ArrayList<PathMapper>();
    private boolean useCacheDecorator = true;
    private Boolean treatWarningsAsErrors = null;
    private Boolean treatMissingArrayIndexAsError = null;
    private Boolean treatMissingValuesAsErrors = null;
    private Boolean treatNullValuesInClassAsErrors = null;
    private System.Logger.Level logLevelForMissingValuesWhenDefaultOrOptional = null;
    private DateTimeFormatter dateDecoderFormat = null;
    private DateTimeFormatter localDateTimeFormat = null;
    private DateTimeFormatter localDateFormat = null;
    private String substitutionOpeningToken = null;
    private String substitutionClosingToken = null;
    private Integer maxSubstitutionNestedDepth = null;
    private String substitutionRegex = null;
    private ProxyDecoderMode proxyDecoderMode = ProxyDecoderMode.CACHE;
    private Tags defaultTags = Tags.of();

    public GestaltBuilder addDefaultDecoders() {
        ArrayList decodersSet = new ArrayList();
        ServiceLoader<Decoder> loader = ServiceLoader.load(Decoder.class);
        loader.forEach(it -> {
            it.applyConfig(this.gestaltConfig);
            decodersSet.add(it);
        });
        this.decoders.addAll(decodersSet);
        return this;
    }

    public GestaltBuilder addDefaultConfigLoaders() {
        ArrayList configLoaderSet = new ArrayList();
        ServiceLoader<ConfigLoader> loader = ServiceLoader.load(ConfigLoader.class);
        loader.forEach(it -> {
            it.applyConfig(this.gestaltConfig);
            configLoaderSet.add(it);
        });
        this.configLoaders.addAll(configLoaderSet);
        return this;
    }

    public GestaltBuilder addDefaultPostProcessors() {
        ArrayList postProcessorsSet = new ArrayList();
        ServiceLoader<PostProcessor> loader = ServiceLoader.load(PostProcessor.class);
        loader.forEach(it -> {
            PostProcessorConfig config = new PostProcessorConfig(this.gestaltConfig, this.configNodeService, this.sentenceLexer);
            it.applyConfig(config);
            postProcessorsSet.add(it);
        });
        this.postProcessors.addAll(postProcessorsSet);
        return this;
    }

    public GestaltBuilder addDefaultPathMappers() {
        ArrayList pathMappersSet = new ArrayList();
        ServiceLoader<PathMapper> loader = ServiceLoader.load(PathMapper.class);
        loader.forEach(it -> {
            it.applyConfig(this.gestaltConfig);
            pathMappersSet.add(it);
        });
        this.pathMappers.addAll(pathMappersSet);
        return this;
    }

    public GestaltBuilder setSources(List<ConfigSource> sources) throws GestaltConfigurationException {
        if (sources == null || sources.isEmpty()) {
            throw new GestaltConfigurationException("No sources provided while setting sources");
        }
        this.sources = sources;
        return this;
    }

    public GestaltBuilder addSources(List<ConfigSource> sources) throws GestaltConfigurationException {
        if (sources == null || sources.isEmpty()) {
            throw new GestaltConfigurationException("No sources provided while adding sources");
        }
        this.sources.addAll(sources);
        return this;
    }

    public GestaltBuilder addSource(ConfigSource source) {
        Objects.requireNonNull(source, "Source should not be null");
        this.sources.add(source);
        return this;
    }

    public GestaltBuilder addReloadStrategy(ConfigReloadStrategy configReloadStrategy) {
        Objects.requireNonNull(configReloadStrategy, "reloadStrategy should not be null");
        this.reloadStrategies.add(configReloadStrategy);
        return this;
    }

    public GestaltBuilder addReloadStrategies(List<ConfigReloadStrategy> reloadStrategies) {
        Objects.requireNonNull(reloadStrategies, "reloadStrategies should not be null");
        this.reloadStrategies.addAll(reloadStrategies);
        return this;
    }

    public GestaltBuilder addCoreReloadListener(CoreReloadListener coreReloadListener) {
        Objects.requireNonNull(coreReloadListener, "coreReloadListener should not be null");
        this.coreCoreReloadListeners.add(coreReloadListener);
        return this;
    }

    public GestaltBuilder addCoreReloadListener(List<CoreReloadListener> coreCoreReloadListeners) {
        Objects.requireNonNull(this.reloadStrategies, "reloadStrategies should not be null");
        this.coreCoreReloadListeners.addAll(coreCoreReloadListeners);
        return this;
    }

    public GestaltBuilder setConfigLoaderService(ConfigLoaderService configLoaderService) {
        Objects.requireNonNull(configLoaderService, "ConfigLoaderRegistry should not be null");
        this.configLoaderService = configLoaderService;
        return this;
    }

    public GestaltBuilder setConfigLoaders(List<ConfigLoader> configLoaders) throws GestaltConfigurationException {
        if (configLoaders == null || configLoaders.isEmpty()) {
            throw new GestaltConfigurationException("No config loader provided while setting config loaders");
        }
        this.configLoaders = configLoaders;
        return this;
    }

    public GestaltBuilder addConfigLoaders(List<ConfigLoader> configLoaders) throws GestaltConfigurationException {
        if (configLoaders == null || configLoaders.isEmpty()) {
            throw new GestaltConfigurationException("No config loader provided while adding config loaders");
        }
        this.configLoaders.addAll(configLoaders);
        return this;
    }

    public GestaltBuilder addConfigLoader(ConfigLoader configLoader) {
        Objects.requireNonNull(configLoader, "ConfigLoader should not be null");
        this.configLoaders.add(configLoader);
        return this;
    }

    public GestaltBuilder setPostProcessors(List<PostProcessor> postProcessors) throws GestaltConfigurationException {
        if (postProcessors == null || postProcessors.isEmpty()) {
            throw new GestaltConfigurationException("No PostProcessors provided while setting");
        }
        this.postProcessors = postProcessors;
        return this;
    }

    public GestaltBuilder addPostProcessors(List<PostProcessor> postProcessors) throws GestaltConfigurationException {
        if (postProcessors == null || postProcessors.isEmpty()) {
            throw new GestaltConfigurationException("No PostProcessor provided while adding");
        }
        this.postProcessors.addAll(postProcessors);
        return this;
    }

    public GestaltBuilder addPostProcessor(PostProcessor postProcessor) {
        Objects.requireNonNull(postProcessor, "PostProcessor should not be null");
        this.postProcessors.add(postProcessor);
        return this;
    }

    public GestaltBuilder setPathMappers(List<PathMapper> pathMappers) throws GestaltConfigurationException {
        if (pathMappers == null || pathMappers.isEmpty()) {
            throw new GestaltConfigurationException("No PathMappers provided while setting");
        }
        this.pathMappers = pathMappers;
        return this;
    }

    public GestaltBuilder addPathMapper(List<PathMapper> pathMappers) throws GestaltConfigurationException {
        if (pathMappers == null || pathMappers.isEmpty()) {
            throw new GestaltConfigurationException("No PathMapper provided while adding");
        }
        this.pathMappers.addAll(pathMappers);
        return this;
    }

    public GestaltBuilder addPathMapper(PathMapper pathMapper) {
        Objects.requireNonNull(pathMapper, "PathMapper should not be null");
        this.pathMappers.add(pathMapper);
        return this;
    }

    public GestaltBuilder setSentenceLexer(SentenceLexer sentenceLexer) {
        Objects.requireNonNull(sentenceLexer, "SentenceLexer should not be null");
        this.sentenceLexer = sentenceLexer;
        return this;
    }

    public GestaltBuilder setGestaltConfig(GestaltConfig gestaltConfig) {
        Objects.requireNonNull(gestaltConfig, "GestaltConfig should not be null");
        this.gestaltConfig = gestaltConfig;
        return this;
    }

    public GestaltBuilder setConfigNodeService(ConfigNodeService configNodeService) {
        Objects.requireNonNull(configNodeService, "ConfigNodeManager should not be null");
        this.configNodeService = configNodeService;
        return this;
    }

    public GestaltBuilder setDecoderService(DecoderService decoderService) {
        Objects.requireNonNull(decoderService, "DecoderService should not be null");
        this.decoderService = decoderService;
        decoderService.addDecoders(this.decoders);
        return this;
    }

    public GestaltBuilder setDecoders(List<Decoder<?>> decoders) throws GestaltConfigurationException {
        if (decoders == null || decoders.isEmpty()) {
            throw new GestaltConfigurationException("No decoders provided while setting decoders");
        }
        this.decoders = decoders;
        return this;
    }

    public GestaltBuilder addDecoders(List<Decoder<?>> decoders) throws GestaltConfigurationException {
        if (decoders == null || decoders.isEmpty()) {
            throw new GestaltConfigurationException("No decoders provided while adding decoders");
        }
        this.decoders.addAll(decoders);
        return this;
    }

    public GestaltBuilder addDecoder(Decoder decoder) {
        Objects.requireNonNull(decoder, "Decoder should not be null");
        this.decoders.add(decoder);
        return this;
    }

    public GestaltBuilder addModuleConfig(GestaltModuleConfig extension) {
        this.modules.put(extension.getClass(), extension);
        return this;
    }

    public GestaltBuilder setTreatWarningsAsErrors(boolean warningsAsErrors) {
        this.treatWarningsAsErrors = warningsAsErrors;
        return this;
    }

    public GestaltBuilder setTreatMissingArrayIndexAsError(Boolean treatMissingArrayIndexAsError) {
        this.treatMissingArrayIndexAsError = treatMissingArrayIndexAsError;
        return this;
    }

    public GestaltBuilder setTreatMissingValuesAsErrors(Boolean treatMissingValuesAsErrors) {
        this.treatMissingValuesAsErrors = treatMissingValuesAsErrors;
        return this;
    }

    public GestaltBuilder setTreatNullValuesInClassAsErrors(Boolean treatNullValuesInClassAsErrors) {
        this.treatNullValuesInClassAsErrors = treatNullValuesInClassAsErrors;
        return this;
    }

    public GestaltBuilder useCacheDecorator(boolean useCacheDecorator) {
        this.useCacheDecorator = useCacheDecorator;
        return this;
    }

    public GestaltBuilder setDateDecoderFormat(DateTimeFormatter dateDecoderFormat) {
        this.dateDecoderFormat = dateDecoderFormat;
        return this;
    }

    public System.Logger.Level getLogLevelForMissingValuesWhenDefaultOrOptional() {
        return this.logLevelForMissingValuesWhenDefaultOrOptional;
    }

    public GestaltBuilder setLogLevelForMissingValuesWhenDefaultOrOptional(System.Logger.Level logLevelForMissingValuesWhenDefaultOrOptional) {
        this.logLevelForMissingValuesWhenDefaultOrOptional = logLevelForMissingValuesWhenDefaultOrOptional;
        return this;
    }

    public GestaltBuilder setLocalDateTimeFormat(DateTimeFormatter localDateTimeFormat) {
        this.localDateTimeFormat = localDateTimeFormat;
        return this;
    }

    public GestaltBuilder setLocalDateFormat(DateTimeFormatter localDateFormat) {
        this.localDateFormat = localDateFormat;
        return this;
    }

    public GestaltBuilder setSubstitutionOpeningToken(String substitutionOpeningToken) {
        this.substitutionOpeningToken = substitutionOpeningToken;
        return this;
    }

    public GestaltBuilder setSubstitutionClosingToken(String substitutionClosingToken) {
        this.substitutionClosingToken = substitutionClosingToken;
        return this;
    }

    public Integer getMaxSubstitutionNestedDepth() {
        return this.maxSubstitutionNestedDepth;
    }

    public GestaltBuilder setMaxSubstitutionNestedDepth(Integer maxSubstitutionNestedDepth) {
        this.maxSubstitutionNestedDepth = maxSubstitutionNestedDepth;
        return this;
    }

    public String getSubstitutionRegex() {
        return this.substitutionRegex;
    }

    public GestaltBuilder setSubstitutionRegex(String substitutionRegex) {
        this.substitutionRegex = substitutionRegex;
        return this;
    }

    public ProxyDecoderMode getProxyDecoderMode() {
        return this.proxyDecoderMode;
    }

    public GestaltBuilder setProxyDecoderMode(ProxyDecoderMode proxyDecoderMode) {
        this.proxyDecoderMode = proxyDecoderMode;
        return this;
    }

    public Tags getDefaultTags() {
        return this.defaultTags;
    }

    public GestaltBuilder setDefaultTags(Tags defaultTags) {
        this.defaultTags = defaultTags;
        return this;
    }

    protected List<Decoder<?>> dedupeDecoders() {
        Map<String, List> decoderMap = this.decoders.stream().collect(Collectors.groupingBy(Decoder::name)).entrySet().stream().filter(it -> ((List)it.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (!decoderMap.isEmpty()) {
            String duplicates = String.join((CharSequence)", ", decoderMap.keySet());
            logger.log(System.Logger.Level.WARNING, "Found duplicate decoders {0}", duplicates);
        }
        return this.decoders.stream().filter(CollectionUtils.distinctBy(Decoder::name)).collect(Collectors.toList());
    }

    protected List<ConfigLoader> dedupeConfigLoaders() {
        Map<String, List> configMap = this.configLoaders.stream().collect(Collectors.groupingBy(ConfigLoader::name)).entrySet().stream().filter(it -> ((List)it.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (!configMap.isEmpty()) {
            String duplicates = String.join((CharSequence)", ", configMap.keySet());
            logger.log(System.Logger.Level.WARNING, "Found duplicate config loaders {0}", duplicates);
        }
        return this.configLoaders.stream().filter(CollectionUtils.distinctBy(ConfigLoader::name)).collect(Collectors.toList());
    }

    public Gestalt build() throws GestaltConfigurationException {
        if (this.sources.isEmpty()) {
            throw new GestaltConfigurationException("No sources provided");
        }
        this.gestaltConfig = this.rebuildConfig();
        this.gestaltConfig.registerModuleConfig(this.modules);
        if (this.decoders.isEmpty()) {
            logger.log(System.Logger.Level.DEBUG, "No decoders provided, using defaults");
            this.addDefaultDecoders();
        }
        if (this.pathMappers.isEmpty()) {
            logger.log(System.Logger.Level.DEBUG, "No path mapper provided, using defaults");
            this.addDefaultPathMappers();
        }
        if (this.decoderService == null) {
            this.decoderService = new DecoderRegistry(this.decoders, this.configNodeService, this.sentenceLexer, this.pathMappers);
        } else {
            this.decoders.addAll(this.decoderService.getDecoders());
            List<Decoder<?>> dedupedDecoders = this.dedupeDecoders();
            this.decoderService.setDecoders(dedupedDecoders);
        }
        if (this.configLoaders.isEmpty()) {
            logger.log(System.Logger.Level.DEBUG, "No decoders provided, using defaults");
            this.addDefaultConfigLoaders();
        }
        if (this.postProcessors.isEmpty()) {
            logger.log(System.Logger.Level.DEBUG, "No post processors provided, using defaults");
            this.addDefaultPostProcessors();
        }
        this.configLoaders.addAll(this.configLoaderService.getConfigLoaders());
        List<ConfigLoader> dedupedConfigs = this.dedupeConfigLoaders();
        this.configLoaderService.setLoaders(dedupedConfigs);
        CoreReloadListenersContainer coreReloadListenersContainer = new CoreReloadListenersContainer();
        GestaltCore gestaltCore = new GestaltCore(this.configLoaderService, this.sources, this.decoderService, this.sentenceLexer, this.gestaltConfig, this.configNodeService, coreReloadListenersContainer, this.postProcessors, this.defaultTags);
        this.reloadStrategies.forEach(it -> it.registerListener(gestaltCore));
        this.coreCoreReloadListeners.forEach(coreReloadListenersContainer::registerListener);
        if (this.useCacheDecorator) {
            GestaltCache gestaltCache = new GestaltCache(gestaltCore, this.defaultTags);
            coreReloadListenersContainer.registerListener(gestaltCache);
            return gestaltCache;
        }
        return gestaltCore;
    }

    private GestaltConfig rebuildConfig() {
        GestaltConfig newConfig = new GestaltConfig();
        newConfig.setTreatWarningsAsErrors(Objects.requireNonNullElseGet(this.treatWarningsAsErrors, () -> this.gestaltConfig.isTreatWarningsAsErrors()));
        newConfig.setTreatMissingArrayIndexAsError(Objects.requireNonNullElseGet(this.treatMissingArrayIndexAsError, () -> this.gestaltConfig.isTreatMissingArrayIndexAsError()));
        newConfig.setTreatMissingValuesAsErrors(Objects.requireNonNullElseGet(this.treatMissingValuesAsErrors, () -> this.gestaltConfig.isTreatMissingValuesAsErrors()));
        newConfig.setTreatNullValuesInClassAsErrors(Objects.requireNonNullElseGet(this.treatNullValuesInClassAsErrors, () -> this.gestaltConfig.isTreatNullValuesInClassAsErrors()));
        newConfig.setLogLevelForMissingValuesWhenDefaultOrOptional(Objects.requireNonNullElseGet(this.logLevelForMissingValuesWhenDefaultOrOptional, () -> this.gestaltConfig.getLogLevelForMissingValuesWhenDefaultOrOptional()));
        newConfig.setDateDecoderFormat(Objects.requireNonNullElseGet(this.dateDecoderFormat, () -> this.gestaltConfig.getDateDecoderFormat()));
        newConfig.setLocalDateTimeFormat(Objects.requireNonNullElseGet(this.localDateTimeFormat, () -> this.gestaltConfig.getLocalDateTimeFormat()));
        newConfig.setLocalDateFormat(Objects.requireNonNullElseGet(this.localDateFormat, () -> this.gestaltConfig.getLocalDateFormat()));
        newConfig.setSubstitutionOpeningToken(Objects.requireNonNullElseGet(this.substitutionOpeningToken, () -> this.gestaltConfig.getSubstitutionOpeningToken()));
        newConfig.setSubstitutionClosingToken(Objects.requireNonNullElseGet(this.substitutionClosingToken, () -> this.gestaltConfig.getSubstitutionClosingToken()));
        newConfig.setMaxSubstitutionNestedDepth(Objects.requireNonNullElseGet(this.maxSubstitutionNestedDepth, () -> this.gestaltConfig.getMaxSubstitutionNestedDepth()));
        newConfig.setSubstitutionRegex(Objects.requireNonNullElseGet(this.substitutionRegex, () -> this.gestaltConfig.getSubstitutionRegex()));
        newConfig.setProxyDecoderMode(Objects.requireNonNullElseGet(this.proxyDecoderMode, () -> this.gestaltConfig.getProxyDecoderMode()));
        return newConfig;
    }
}

