/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.github.gestalt.config.decoder.Decoder;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.node.ArrayNode;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.PathUtil;
import org.github.gestalt.config.utils.ValidateOf;

public final class ArrayDecoder<T>
implements Decoder<T[]> {
    @Override
    public Priority priority() {
        return Priority.MEDIUM;
    }

    @Override
    public String name() {
        return "Array";
    }

    @Override
    public boolean matches(TypeCapture<?> type) {
        return type.isArray();
    }

    @Override
    public ValidateOf<T[]> decode(String path, Tags tags, ConfigNode node, TypeCapture<?> type, DecoderContext decoderContext) {
        ValidateOf<Object> results;
        if (node instanceof ArrayNode) {
            results = node.size() > 0 ? this.arrayDecode(path, tags, node, type, decoderContext) : ValidateOf.inValid(new ValidationError.DecodingArrayMissingValue(path, this.name()));
        } else if (node instanceof LeafNode) {
            if (node.getValue().isPresent()) {
                String value = node.getValue().get();
                String[] array = value.split("(?<!\\\\),");
                List<ConfigNode> leafNodes = Arrays.stream(array).map(String::trim).map(it -> it.replace("\\,", ",")).map(LeafNode::new).collect(Collectors.toList());
                results = this.arrayDecode(path, tags, new ArrayNode(leafNodes), type, decoderContext);
            } else {
                results = ValidateOf.inValid(new ValidationError.DecodingLeafMissingValue(path, this.name()));
            }
        } else {
            results = ValidateOf.inValid(new ValidationError.DecodingExpectedArrayNodeType(path, node, this.name()));
        }
        return results;
    }

    private ValidateOf<T[]> arrayDecode(String path, Tags tags, ConfigNode node, TypeCapture<?> klass, DecoderContext decoderContext) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        Object[] results = (Object[])Array.newInstance(klass.getComponentType(), node.size());
        for (int i = 0; i < node.size(); ++i) {
            if (node.getIndex(i).isPresent()) {
                ConfigNode currentNode = node.getIndex(i).get();
                String nextPath = PathUtil.pathForIndex(path, i);
                ValidateOf<?> validateOf = decoderContext.getDecoderService().decodeNode(nextPath, tags, currentNode, TypeCapture.of(klass.getComponentType()), decoderContext);
                errors.addAll(validateOf.getErrors());
                if (!validateOf.hasResults()) continue;
                results[i] = validateOf.results();
                continue;
            }
            errors.add(new ValidationError.ArrayMissingIndex(i));
            results[i] = null;
        }
        return ValidateOf.validateOf(results, errors);
    }
}

