/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.nio.charset.Charset;
import org.github.gestalt.config.decoder.LeafDecoder;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.utils.ValidateOf;

public final class ByteDecoder
extends LeafDecoder<Byte> {
    @Override
    public Priority priority() {
        return Priority.MEDIUM;
    }

    @Override
    public String name() {
        return "Byte";
    }

    @Override
    public boolean matches(TypeCapture<?> klass) {
        return Byte.class.isAssignableFrom(klass.getRawType()) || Byte.TYPE.isAssignableFrom(klass.getRawType());
    }

    @Override
    protected ValidateOf<Byte> leafDecode(String path, ConfigNode node) {
        String value = node.getValue().orElse("");
        ValidateOf<Byte> results = value.length() == 1 ? ValidateOf.valid(value.getBytes(Charset.defaultCharset())[0]) : ValidateOf.inValid(new ValidationError.DecodingByteTooLong(path, node));
        return results;
    }
}

