/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.util.ArrayList;
import org.github.gestalt.config.decoder.LeafDecoder;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.utils.ValidateOf;

public final class CharDecoder
extends LeafDecoder<Character> {
    @Override
    public Priority priority() {
        return Priority.MEDIUM;
    }

    @Override
    public String name() {
        return "Character";
    }

    @Override
    public boolean matches(TypeCapture<?> klass) {
        return Character.class.isAssignableFrom(klass.getRawType()) || Character.TYPE.isAssignableFrom(klass.getRawType());
    }

    @Override
    protected ValidateOf<Character> leafDecode(String path, ConfigNode node) {
        Character results = null;
        ArrayList<ValidationError> error = new ArrayList<ValidationError>();
        String value = node.getValue().orElse("");
        if (!value.isEmpty()) {
            results = Character.valueOf(value.charAt(0));
        }
        if (value.length() != 1) {
            error.add(new ValidationError.DecodingCharWrongSize(path, node));
        }
        return ValidateOf.validateOf(results, error);
    }
}

