/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.github.gestalt.config.decoder.Decoder;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.node.ArrayNode;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.ValidateOf;

public abstract class CollectionDecoder<T extends Collection<?>>
implements Decoder<T> {
    @Override
    public Priority priority() {
        return Priority.MEDIUM;
    }

    @Override
    public ValidateOf<T> decode(String path, Tags tags, ConfigNode node, TypeCapture<?> type, DecoderContext decoderContext) {
        ValidateOf<T> results;
        if (node instanceof ArrayNode) {
            results = node.size() > 0 ? this.arrayDecode(path, tags, node, type, decoderContext) : ValidateOf.inValid(new ValidationError.DecodingArrayMissingValue(path, this.name()));
        } else if (node instanceof LeafNode) {
            if (node.getValue().isPresent()) {
                String value = node.getValue().get();
                String[] array = value.split("(?<!\\\\),");
                List<ConfigNode> leafNodes = Arrays.stream(array).map(String::trim).map(it -> it.replace("\\,", ",")).map(LeafNode::new).collect(Collectors.toList());
                results = this.arrayDecode(path, tags, new ArrayNode(leafNodes), type, decoderContext);
            } else {
                results = ValidateOf.inValid(new ValidationError.DecodingLeafMissingValue(path, this.name()));
            }
        } else {
            results = ValidateOf.inValid(new ValidationError.DecodingExpectedArrayNodeType(path, node, this.name()));
        }
        return results;
    }

    protected abstract ValidateOf<T> arrayDecode(String var1, Tags var2, ConfigNode var3, TypeCapture<?> var4, DecoderContext var5);
}

