/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.github.gestalt.config.decoder.LeafDecoder;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.utils.ValidateOf;

public final class EnumDecoder<T extends Enum<T>>
extends LeafDecoder<T> {
    @Override
    public Priority priority() {
        return Priority.MEDIUM;
    }

    @Override
    public String name() {
        return "Enum";
    }

    @Override
    public boolean matches(TypeCapture<?> klass) {
        return klass.getRawType().isEnum();
    }

    @Override
    protected ValidateOf<T> leafDecode(String path, ConfigNode node, TypeCapture<?> type) {
        String value = node.getValue().orElse("");
        try {
            ?[] enumConstants;
            Class<?> klass = type.getRawType();
            Method m = klass.getMethod("name", new Class[0]);
            for (Object enumConst : enumConstants = klass.getEnumConstants()) {
                Object enumName = m.invoke(enumConst, new Object[0]);
                if (!(enumName instanceof String) || !value.equalsIgnoreCase((String)enumName)) continue;
                return ValidateOf.valid((Enum)enumConst);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return ValidateOf.inValid(new ValidationError.ExceptionDecodingEnum(path, value, type.getRawType(), e));
        }
        return ValidateOf.inValid(new ValidationError.EnumValueNotFound(path, value, type.getRawType()));
    }

    @Override
    protected ValidateOf<T> leafDecode(String path, ConfigNode node) {
        return null;
    }
}

