/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.time.Instant;
import java.time.format.DateTimeParseException;
import org.github.gestalt.config.decoder.LeafDecoder;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.utils.ValidateOf;

public final class InstantDecoder
extends LeafDecoder<Instant> {
    @Override
    public Priority priority() {
        return Priority.MEDIUM;
    }

    @Override
    public String name() {
        return "Instant";
    }

    @Override
    public boolean matches(TypeCapture<?> klass) {
        return Instant.class.isAssignableFrom(klass.getRawType());
    }

    @Override
    protected ValidateOf<Instant> leafDecode(String path, ConfigNode node) {
        ValidateOf<Instant> results;
        String value = node.getValue().orElse("");
        try {
            Instant instant = Instant.parse(value);
            results = ValidateOf.valid(instant);
        }
        catch (DateTimeParseException e) {
            results = ValidateOf.inValid(new ValidationError.ErrorDecodingException(path, node, this.name()));
        }
        return results;
    }
}

