/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import org.github.gestalt.config.decoder.LeafDecoder;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.utils.StringUtils;
import org.github.gestalt.config.utils.ValidateOf;

public final class IntegerDecoder
extends LeafDecoder<Integer> {
    @Override
    public Priority priority() {
        return Priority.MEDIUM;
    }

    @Override
    public String name() {
        return "Integer";
    }

    @Override
    public boolean matches(TypeCapture<?> klass) {
        return Integer.class.isAssignableFrom(klass.getRawType()) || Integer.TYPE.isAssignableFrom(klass.getRawType());
    }

    @Override
    protected ValidateOf<Integer> leafDecode(String path, ConfigNode node) {
        ValidateOf<Integer> results;
        String value = node.getValue().orElse("");
        if (StringUtils.isInteger(value)) {
            try {
                Integer intVal = Integer.parseInt(value);
                results = ValidateOf.valid(intVal);
            }
            catch (NumberFormatException e) {
                results = ValidateOf.inValid(new ValidationError.DecodingNumberFormatException(path, node, this.name()));
            }
        } else {
            results = ValidateOf.inValid(new ValidationError.DecodingNumberParsing(path, node, this.name()));
        }
        return results;
    }
}

