/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.github.gestalt.config.decoder.LeafDecoder;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.entity.GestaltConfig;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.utils.ValidateOf;

public final class LocalDateTimeDecoder
extends LeafDecoder<LocalDateTime> {
    private DateTimeFormatter formatter;

    public LocalDateTimeDecoder() {
        this.formatter = DateTimeFormatter.ISO_DATE_TIME;
    }

    public LocalDateTimeDecoder(String formatter) {
        this.formatter = formatter != null && !formatter.isEmpty() ? DateTimeFormatter.ofPattern(formatter) : DateTimeFormatter.ISO_DATE_TIME;
    }

    @Override
    public void applyConfig(GestaltConfig config) {
        if (config.getDateDecoderFormat() != null && this.formatter.equals(DateTimeFormatter.ISO_DATE_TIME)) {
            this.formatter = config.getDateDecoderFormat();
        }
    }

    @Override
    public Priority priority() {
        return Priority.MEDIUM;
    }

    @Override
    public String name() {
        return "LocalDateTime";
    }

    @Override
    public boolean matches(TypeCapture<?> klass) {
        return LocalDateTime.class.isAssignableFrom(klass.getRawType());
    }

    @Override
    protected ValidateOf<LocalDateTime> leafDecode(String path, ConfigNode node) {
        ValidateOf<LocalDateTime> results;
        String value = node.getValue().orElse("");
        try {
            results = ValidateOf.valid(LocalDateTime.parse(value, this.formatter));
        }
        catch (DateTimeParseException e) {
            results = ValidateOf.inValid(new ValidationError.ErrorDecodingException(path, node, this.name()));
        }
        return results;
    }
}

