/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.github.gestalt.config.decoder.Decoder;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.node.ArrayNode;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.node.MapNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.ClassUtils;
import org.github.gestalt.config.utils.Pair;
import org.github.gestalt.config.utils.PathUtil;
import org.github.gestalt.config.utils.ValidateOf;

public final class MapDecoder
implements Decoder<Map<?, ?>> {
    @Override
    public Priority priority() {
        return Priority.MEDIUM;
    }

    @Override
    public String name() {
        return "Map";
    }

    @Override
    public boolean matches(TypeCapture<?> type) {
        return Map.class.isAssignableFrom(type.getRawType()) && type.hasParameter();
    }

    @Override
    public ValidateOf<Map<?, ?>> decode(String path, Tags tags, ConfigNode node, TypeCapture<?> type, DecoderContext decoderContext) {
        List<TypeCapture<?>> genericInterfaces;
        if (node instanceof MapNode) {
            MapNode mapNode = (MapNode)node;
            genericInterfaces = type.getParameterTypes();
            if (genericInterfaces != null && genericInterfaces.size() == 2) {
                TypeCapture<?> keyType = genericInterfaces.get(0);
                TypeCapture<?> valueType = genericInterfaces.get(1);
                ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
                Stream<Object> stream = mapNode.getMapNode().entrySet().stream();
                if (ClassUtils.isPrimitiveOrWrapper(valueType.getRawType())) {
                    stream = stream.flatMap(it -> this.convertMapToStream((String)it.getKey(), (Map.Entry<String, ConfigNode>)it));
                }
                Map map = stream.map(it -> {
                    String key = (String)it.getKey();
                    if (key == null) {
                        errors.add(new ValidationError.DecodersMapKeyNull(path));
                        return null;
                    }
                    String nextPath = PathUtil.pathForKey(path, key);
                    ValidateOf keyValidate = decoderContext.getDecoderService().decodeNode(nextPath, tags, new LeafNode(key), keyType, decoderContext);
                    ValidateOf valueValidate = decoderContext.getDecoderService().decodeNode(nextPath, tags, (ConfigNode)it.getValue(), valueType, decoderContext);
                    errors.addAll(keyValidate.getErrors());
                    errors.addAll(valueValidate.getErrors());
                    if (!keyValidate.hasResults()) {
                        errors.add(new ValidationError.DecodersMapKeyNull(nextPath));
                    }
                    if (!valueValidate.hasResults()) {
                        errors.add(new ValidationError.DecodersMapValueNull(nextPath));
                    }
                    if (keyValidate.hasResults()) {
                        return new Pair(keyValidate.results(), valueValidate.results());
                    }
                    return null;
                }).filter(Objects::nonNull).collect(HashMap::new, (m, v) -> m.put(v.getFirst(), v.getSecond()), HashMap::putAll);
                return ValidateOf.validateOf(map, errors);
            }
        } else {
            return ValidateOf.inValid(new ValidationError.DecodingExpectedMapNodeType(path, node));
        }
        ValidateOf<Map<?, ?>> results = ValidateOf.inValid(new ValidationError.DecodingExpectedMapNodeType(path, genericInterfaces, node));
        return results;
    }

    private Stream<Map.Entry<String, ConfigNode>> convertMapToStream(String path, Map.Entry<String, ConfigNode> entry) {
        if (path == null || entry.getValue() == null) {
            return Stream.of(entry);
        }
        if (entry.getValue() instanceof MapNode) {
            MapNode node = (MapNode)entry.getValue();
            return node.getMapNode().entrySet().stream().flatMap(it -> this.convertMapToStream(path + "." + (String)it.getKey(), (Map.Entry<String, ConfigNode>)it));
        }
        if (entry.getValue() instanceof ArrayNode) {
            ArrayNode node = (ArrayNode)entry.getValue();
            Stream<Map.Entry<String, ConfigNode>> stream = Stream.of(new Map.Entry[0]);
            List<ConfigNode> nodes = node.getArray();
            for (int i = 0; i < nodes.size(); ++i) {
                stream = Stream.concat(stream, this.convertMapToStream(path + "[" + i + "]", Map.entry("[" + i + "]", nodes.get(i))));
            }
            return stream;
        }
        if (entry.getValue() instanceof LeafNode) {
            return Stream.of(Map.entry(path, entry.getValue()));
        }
        return Stream.of(new Map.Entry[0]);
    }
}

