/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.github.gestalt.config.annotations.Config;
import org.github.gestalt.config.decoder.Decoder;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.node.MapNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.ClassUtils;
import org.github.gestalt.config.utils.PathUtil;
import org.github.gestalt.config.utils.ValidateOf;

public final class ObjectDecoder
implements Decoder<Object> {
    private static final System.Logger logger = System.getLogger(ObjectDecoder.class.getName());
    private final Set<Class<?>> ignoreTypes = this.getIgnoreTypes();

    @Override
    public Priority priority() {
        return Priority.VERY_LOW;
    }

    @Override
    public String name() {
        return "Object";
    }

    @Override
    public boolean matches(TypeCapture<?> klass) {
        return !klass.getRawType().isPrimitive() && !klass.isArray() && !klass.isEnum() && !klass.hasParameter() && !klass.isInterface() && !this.ignoreTypes.contains(klass.getRawType());
    }

    private Set<Class<?>> getIgnoreTypes() {
        return new HashSet(List.of(Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Short.class, String.class, Void.class));
    }

    @Override
    public ValidateOf<Object> decode(String path, Tags tags, ConfigNode node, TypeCapture<?> type, DecoderContext decoderContext) {
        if (!(node instanceof MapNode)) {
            List<TypeCapture<?>> genericInterfaces = type.getParameterTypes();
            return ValidateOf.inValid(new ValidationError.DecodingExpectedMapNodeType(path, genericInterfaces, node));
        }
        Class<?> klass = type.getRawType();
        try {
            Constructor<?> constructor = klass.getDeclaredConstructor(new Class[0]);
            if (Modifier.isPrivate(constructor.getModifiers())) {
                return ValidateOf.inValid(new ValidationError.ConstructorNotPublic(path, klass.getName()));
            }
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            Object obj = klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            List<Field> classFields = this.getClassFields(klass);
            for (Field field : classFields) {
                Object value;
                int modifiers = field.getModifiers();
                String fieldName = field.getName();
                if (Modifier.isStatic(modifiers)) {
                    logger.log(System.Logger.Level.INFO, "Ignoring static field for class: " + klass.getName() + " field " + fieldName);
                    continue;
                }
                Type fieldClass = field.getGenericType();
                TypeCapture fieldType = TypeCapture.of(fieldClass);
                String name = this.getFieldAnnotationValue(klass, field, fieldName, fieldClass, Config::path);
                name = name.isEmpty() ? fieldName : name;
                String nextPath = PathUtil.pathForKey(path, name);
                ValidateOf<ConfigNode> configNode = decoderContext.getDecoderService().getNextNode(nextPath, name, node);
                errors.addAll(configNode.getErrors());
                if (configNode.hasResults()) {
                    ValidateOf fieldValidateOf = decoderContext.getDecoderService().decodeNode(nextPath, tags, configNode.results(), fieldType, decoderContext);
                    errors.addAll(fieldValidateOf.getErrors());
                    if (fieldValidateOf.hasResults()) {
                        this.setField(obj, field, klass, fieldValidateOf.results());
                        continue;
                    }
                    Object value2 = this.getObject(obj, field, klass);
                    if (value2 == null) {
                        errors.add(new ValidationError.NullValueDecodingObject(nextPath, fieldName, klass.getSimpleName()));
                        continue;
                    }
                    errors.add(new ValidationError.NoResultsFoundForNode(nextPath, field.getType(), "object decoding"));
                    continue;
                }
                String defaultValue = this.getFieldAnnotationValue(klass, field, fieldName, fieldClass, Config::defaultVal);
                if (!defaultValue.isEmpty()) {
                    ValidateOf defaultValidateOf = decoderContext.getDecoderService().decodeNode(nextPath, tags, new LeafNode(defaultValue), fieldType, decoderContext);
                    errors.addAll(defaultValidateOf.getErrors());
                    if (defaultValidateOf.hasResults()) {
                        this.setField(obj, field, klass, defaultValidateOf.results());
                        continue;
                    }
                    value = this.getObject(obj, field, klass);
                    if (value != null) continue;
                    errors.add(new ValidationError.NullValueDecodingObject(nextPath, fieldName, klass.getSimpleName()));
                    continue;
                }
                ValidateOf decodedResults = decoderContext.getDecoderService().decodeNode(nextPath, tags, configNode.results(), fieldType, decoderContext);
                if (decodedResults.hasResults()) {
                    this.setField(obj, field, klass, decodedResults.results());
                    continue;
                }
                value = this.getObject(obj, field, klass);
                if (value != null) continue;
                errors.add(new ValidationError.NullValueDecodingObject(nextPath, fieldName, klass.getSimpleName()));
            }
            return ValidateOf.validateOf(obj, errors);
        }
        catch (NoSuchMethodException e) {
            return ValidateOf.inValid(new ValidationError.NoDefaultConstructor(path, klass.getName()));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            return ValidateOf.inValid(new ValidationError.ConstructorNotPublic(path, klass.getName()));
        }
    }

    private Object getObject(Object obj, Field field, Class<?> klass) throws IllegalAccessException {
        String methodName = field.getType().equals(Boolean.TYPE) ? "is" + field.getName() : "get" + field.getName();
        Optional<Method> method = this.getMethod(klass, methodName);
        if (method.isPresent()) {
            try {
                return method.get().invoke(obj, new Object[0]);
            }
            catch (InvocationTargetException e) {
                logger.log(System.Logger.Level.WARNING, "Failed to get value calling method " + methodName + ", on class " + klass.getSimpleName() + ", for field " + field.getName());
            }
        }
        field.setAccessible(true);
        return field.get(obj);
    }

    private String getFieldAnnotationValue(Class<?> klass, Field field, String fieldName, Type fieldClass, Function<Config, String> get) {
        String value = "";
        Optional<Config> configAnnotation = Optional.ofNullable(field.getAnnotation(Config.class));
        if (configAnnotation.isPresent() && get.apply(configAnnotation.get()) != null && !get.apply(configAnnotation.get()).isEmpty()) {
            value = get.apply(configAnnotation.get());
        } else {
            configAnnotation = this.findMethodConfig(klass, fieldName, fieldClass, get);
            if (configAnnotation.isPresent() && get.apply(configAnnotation.get()) != null && !get.apply(configAnnotation.get()).isEmpty()) {
                value = get.apply(configAnnotation.get());
            }
        }
        return value;
    }

    private Optional<Config> findMethodConfig(Class<?> klass, String fieldName, Type fieldClass, Function<Config, String> get) {
        String methodName = fieldClass.equals(Boolean.TYPE) || fieldClass.equals(Boolean.TYPE) ? "is" + fieldName : "get" + fieldName;
        Optional<Config> configAnnotation = this.getMethodAnnotation(klass, methodName, get).or(() -> this.getMethodAnnotation(klass, fieldName, get));
        return configAnnotation;
    }

    private Optional<Config> getMethodAnnotation(Class<?> klass, String methodName, Function<Config, String> get) {
        Config methodConfigAnnotation;
        Config result = null;
        Optional<Method> method = this.getMethod(klass, methodName);
        if (method.isPresent() && (methodConfigAnnotation = method.get().getAnnotation(Config.class)) != null && get.apply(methodConfigAnnotation) != null && !get.apply(methodConfigAnnotation).isEmpty()) {
            result = method.get().getAnnotation(Config.class);
        }
        return Optional.ofNullable(result);
    }

    private Optional<Method> getMethod(Class<?> klass, String methodName) {
        return Arrays.stream(klass.getMethods()).filter(it -> it.getName().equalsIgnoreCase(methodName)).findFirst();
    }

    private void setField(Object obj, Field field, Class<?> klass, Object value) throws IllegalAccessException {
        String methodName = "set" + field.getName();
        Optional<Method> setMethod = this.getMethod(klass, methodName);
        if (setMethod.isPresent() && setMethod.get().getParameterCount() == 1 && ClassUtils.isAssignable(setMethod.get().getParameters()[0].getType(), value.getClass())) {
            try {
                setMethod.get().invoke(obj, value);
            }
            catch (InvocationTargetException e) {
                logger.log(System.Logger.Level.WARNING, "unable to set field " + field.getName() + " using method " + methodName + ", on class " + klass.getSimpleName() + ", for val: " + value + ", setting field directly");
                field.setAccessible(true);
                field.set(obj, value);
            }
        } else {
            field.setAccessible(true);
            field.set(obj, value);
        }
    }

    private List<Field> getClassFields(Class<?> klass) {
        ArrayList<Field> classFields = new ArrayList<Field>();
        for (Class<?> currentClass = klass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Field[] fields = currentClass.getDeclaredFields();
            classFields.addAll(List.of(fields));
        }
        return classFields;
    }
}

