/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.util.Optional;
import org.github.gestalt.config.decoder.Decoder;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.ValidateOf;

public final class OptionalDecoder
implements Decoder<Optional<?>> {
    @Override
    public Priority priority() {
        return Priority.MEDIUM;
    }

    @Override
    public String name() {
        return "Optional";
    }

    @Override
    public boolean matches(TypeCapture<?> type) {
        return Optional.class.isAssignableFrom(type.getRawType());
    }

    @Override
    public ValidateOf<Optional<?>> decode(String path, Tags tags, ConfigNode node, TypeCapture<?> type, DecoderContext decoderContext) {
        ValidateOf<?> optionalValue = decoderContext.getDecoderService().decodeNode(path, tags, node, type.getFirstParameterType(), decoderContext);
        return ValidateOf.validateOf(Optional.ofNullable(optionalValue.results()), optionalValue.getErrors());
    }
}

