/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.util.OptionalDouble;
import org.github.gestalt.config.decoder.Decoder;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.ValidateOf;

public final class OptionalDoubleDecoder
implements Decoder<OptionalDouble> {
    @Override
    public Priority priority() {
        return Priority.MEDIUM;
    }

    @Override
    public String name() {
        return "OptionalDouble";
    }

    @Override
    public boolean matches(TypeCapture<?> type) {
        return OptionalDouble.class.isAssignableFrom(type.getRawType());
    }

    @Override
    public ValidateOf<OptionalDouble> decode(String path, Tags tags, ConfigNode node, TypeCapture<?> type, DecoderContext decoderContext) {
        ValidateOf<Double> optionalValue = decoderContext.getDecoderService().decodeNode(path, tags, node, TypeCapture.of(Double.class), decoderContext);
        if (optionalValue.hasResults()) {
            return ValidateOf.validateOf(OptionalDouble.of(optionalValue.results()), optionalValue.getErrors());
        }
        return ValidateOf.validateOf(OptionalDouble.empty(), optionalValue.getErrors());
    }
}

