/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.util.OptionalInt;
import org.github.gestalt.config.decoder.Decoder;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.ValidateOf;

public final class OptionalIntDecoder
implements Decoder<OptionalInt> {
    @Override
    public Priority priority() {
        return Priority.MEDIUM;
    }

    @Override
    public String name() {
        return "OptionalInt";
    }

    @Override
    public boolean matches(TypeCapture<?> type) {
        return OptionalInt.class.isAssignableFrom(type.getRawType());
    }

    @Override
    public ValidateOf<OptionalInt> decode(String path, Tags tags, ConfigNode node, TypeCapture<?> type, DecoderContext decoderContext) {
        ValidateOf<Integer> optionalValue = decoderContext.getDecoderService().decodeNode(path, tags, node, TypeCapture.of(Integer.class), decoderContext);
        if (optionalValue.hasResults()) {
            return ValidateOf.validateOf(OptionalInt.of(optionalValue.results()), optionalValue.getErrors());
        }
        return ValidateOf.validateOf(OptionalInt.empty(), optionalValue.getErrors());
    }
}

