/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.github.gestalt.config.annotations.Config;
import org.github.gestalt.config.decoder.Decoder;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.decoder.DecoderService;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.decoder.ProxyDecoderMode;
import org.github.gestalt.config.entity.GestaltConfig;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.exceptions.GestaltException;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.node.MapNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.PathUtil;
import org.github.gestalt.config.utils.ValidateOf;

public final class ProxyDecoder
implements Decoder<Object> {
    private ProxyDecoderMode proxyDecoderMode = ProxyDecoderMode.CACHE;

    private static String getConfigName(String methodName, Type returnType) {
        String name = methodName;
        if (methodName.startsWith("get")) {
            name = methodName.substring(3);
        } else if (methodName.startsWith("is") && (returnType.equals(Boolean.TYPE) || returnType.equals(Boolean.TYPE))) {
            name = methodName.substring(2);
        }
        char[] nameArray = name.toCharArray();
        nameArray[0] = Character.toLowerCase(nameArray[0]);
        return new String(nameArray);
    }

    @Override
    public void applyConfig(GestaltConfig config) {
        this.proxyDecoderMode = config.getProxyDecoderMode();
    }

    @Override
    public Priority priority() {
        return Priority.LOW;
    }

    @Override
    public String name() {
        return "proxy";
    }

    @Override
    public boolean matches(TypeCapture<?> klass) {
        return klass.isInterface() && !Collection.class.isAssignableFrom(klass.getRawType()) && !Map.class.isAssignableFrom(klass.getRawType());
    }

    @Override
    public ValidateOf<Object> decode(String path, Tags tags, ConfigNode node, TypeCapture<?> type, DecoderContext decoderContext) {
        InvocationHandler proxyHandler;
        if (!(node instanceof MapNode)) {
            return ValidateOf.inValid(new ValidationError.DecodingExpectedMapNodeType(path, node));
        }
        Class<?> klass = type.getRawType();
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        Method[] classMethods = klass.getMethods();
        DecoderService decoderService = decoderContext.getDecoderService();
        HashMap<String, Object> methodResults = new HashMap<String, Object>();
        for (Method method : classMethods) {
            String methodName = method.getName();
            Type returnType = method.getGenericReturnType();
            boolean foundValue = false;
            Config configAnnotation = method.getAnnotation(Config.class);
            String name = configAnnotation != null && configAnnotation.path() != null && !configAnnotation.path().isEmpty() ? configAnnotation.path() : ProxyDecoder.getConfigName(methodName, returnType);
            String nextPath = PathUtil.pathForKey(path, name);
            ValidateOf<ConfigNode> configNode = decoderService.getNextNode(nextPath, name, node);
            errors.addAll(configNode.getErrors());
            if (!configNode.hasResults()) {
                if (configAnnotation != null && configAnnotation.defaultVal() != null && !configAnnotation.defaultVal().isEmpty()) {
                    ValidateOf defaultValidateOf = decoderService.decodeNode(nextPath, tags, new LeafNode(configAnnotation.defaultVal()), TypeCapture.of(returnType), decoderContext);
                    errors.addAll(defaultValidateOf.getErrors());
                    if (defaultValidateOf.hasResults()) {
                        methodResults.put(methodName, defaultValidateOf.results());
                        foundValue = true;
                    }
                }
            } else {
                ValidateOf fieldValidateOf = decoderService.decodeNode(nextPath, tags, configNode.results(), TypeCapture.of(returnType), decoderContext);
                errors.addAll(fieldValidateOf.getErrors());
                if (fieldValidateOf.hasResults()) {
                    methodResults.put(methodName, fieldValidateOf.results());
                    foundValue = true;
                }
            }
            if (foundValue || method.isDefault()) continue;
            errors.add(new ValidationError.NullValueDecodingObject(nextPath, name, klass.getSimpleName()));
        }
        switch (this.proxyDecoderMode) {
            case PASSTHROUGH: {
                proxyHandler = new ProxyPassThroughInvocationHandler(path, tags, decoderContext);
                break;
            }
            default: {
                proxyHandler = new ProxyCacheInvocationHandler(path, methodResults);
            }
        }
        Object myProxy = Proxy.newProxyInstance(type.getRawType().getClassLoader(), new Class[]{type.getRawType()}, proxyHandler);
        return ValidateOf.validateOf(myProxy, errors);
    }

    private static class ProxyPassThroughInvocationHandler
    implements InvocationHandler {
        private final String path;
        private final Tags tags;
        private final DecoderContext decoderContext;

        private ProxyPassThroughInvocationHandler(String path, Tags tags, DecoderContext decoderContext) {
            this.path = path;
            this.tags = tags;
            this.decoderContext = decoderContext;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            ValidateOf<?> defaultValidateOf;
            String methodName = method.getName();
            boolean isDefault = method.isDefault();
            Type genericType = method.getGenericReturnType();
            Class<?> returnType = method.getReturnType();
            Config configAnnotation = method.getAnnotation(Config.class);
            String name = configAnnotation != null && configAnnotation.path() != null && !configAnnotation.path().isEmpty() ? configAnnotation.path() : ProxyDecoder.getConfigName(methodName, returnType);
            String nextPath = PathUtil.pathForKey(this.path, name);
            Optional result = this.decoderContext.getGestalt().getConfigOptional(nextPath, TypeCapture.of(genericType), this.tags);
            if (result != null && result.isPresent()) {
                return result.get();
            }
            if (configAnnotation != null && configAnnotation.defaultVal() != null && !configAnnotation.defaultVal().isEmpty() && (defaultValidateOf = this.decoderContext.getDecoderService().decodeNode(nextPath, this.tags, new LeafNode(configAnnotation.defaultVal()), TypeCapture.of(returnType), this.decoderContext)).hasResults()) {
                return defaultValidateOf.results();
            }
            if (isDefault) {
                return MethodHandles.lookup().findSpecial(method.getDeclaringClass(), methodName, MethodType.methodType(returnType, new Class[0]), method.getDeclaringClass()).bindTo(proxy).invokeWithArguments(args);
            }
            throw new GestaltException("Failed to get pass through object from proxy config while calling method: " + methodName + " with type: " + returnType + " in path: " + this.path + ".");
        }
    }

    private static class ProxyCacheInvocationHandler
    implements InvocationHandler {
        private final String path;
        private final Map<String, Object> methodResults;

        private ProxyCacheInvocationHandler(String path, Map<String, Object> methodResults) {
            this.path = path;
            this.methodResults = methodResults;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            boolean isDefault = method.isDefault();
            Object result = this.methodResults.get(methodName);
            Class<?> type = method.getReturnType();
            if (result != null) {
                return result;
            }
            if (isDefault) {
                return MethodHandles.lookup().findSpecial(method.getDeclaringClass(), methodName, MethodType.methodType(type, new Class[0]), method.getDeclaringClass()).bindTo(proxy).invokeWithArguments(args);
            }
            throw new GestaltException("Failed to get cached object from proxy config while calling method: " + methodName + " with type: " + type + " in path: " + this.path + ".");
        }
    }
}

