/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import org.github.gestalt.config.annotations.Config;
import org.github.gestalt.config.decoder.Decoder;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.decoder.DecoderService;
import org.github.gestalt.config.decoder.Priority;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.node.LeafNode;
import org.github.gestalt.config.node.MapNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.PathUtil;
import org.github.gestalt.config.utils.RecComponent;
import org.github.gestalt.config.utils.RecordUtils;
import org.github.gestalt.config.utils.ValidateOf;

public final class RecordDecoder
implements Decoder<Object> {
    @Override
    public Priority priority() {
        return Priority.MEDIUM;
    }

    @Override
    public String name() {
        return "Record";
    }

    @Override
    public boolean matches(TypeCapture<?> klass) {
        return RecordUtils.isRecord(klass.getRawType());
    }

    @Override
    public ValidateOf<Object> decode(String path, Tags tags, ConfigNode node, TypeCapture<?> type, DecoderContext decoderContext) {
        if (!(node instanceof MapNode)) {
            return ValidateOf.inValid(new ValidationError.DecodingExpectedLeafNodeType(path, node, this.name()));
        }
        boolean hasAllValues = true;
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        Class<?> klass = type.getRawType();
        DecoderService decoderService = decoderContext.getDecoderService();
        RecComponent[] recordComponents = RecordUtils.recordComponents(klass, Comparator.comparing(RecComponent::index));
        Object[] values = new Object[recordComponents.length];
        for (int i = 0; i < recordComponents.length; ++i) {
            RecComponent rc = recordComponents[i];
            String name = rc.name();
            Config configAnnotation = rc.getAccessor().getAnnotation(Config.class);
            if (configAnnotation != null && configAnnotation.path() != null && !configAnnotation.path().isEmpty()) {
                name = configAnnotation.path();
            }
            Type fieldClass = rc.typeGeneric();
            String nextPath = PathUtil.pathForKey(path, name);
            ValidateOf<ConfigNode> configNode = decoderService.getNextNode(nextPath, name, node);
            TypeCapture typeCapture = TypeCapture.of(fieldClass);
            errors.addAll(configNode.getErrors());
            if (!configNode.hasResults()) {
                if (configAnnotation != null && configAnnotation.defaultVal() != null && !configAnnotation.defaultVal().isEmpty()) {
                    ValidateOf defaultValidateOf = decoderService.decodeNode(nextPath, tags, new LeafNode(configAnnotation.defaultVal()), typeCapture, decoderContext);
                    errors.addAll(defaultValidateOf.getErrors());
                    if (defaultValidateOf.hasResults()) {
                        values[i] = defaultValidateOf.results();
                        continue;
                    }
                    hasAllValues = false;
                    continue;
                }
                ValidateOf decodedResults = decoderService.decodeNode(nextPath, tags, configNode.results(), typeCapture, decoderContext);
                if (decodedResults.hasResults()) {
                    values[i] = decodedResults.results();
                    continue;
                }
                hasAllValues = false;
                continue;
            }
            ValidateOf fieldValidateOf = decoderService.decodeNode(nextPath, tags, configNode.results(), typeCapture, decoderContext);
            errors.addAll(fieldValidateOf.getErrors());
            if (fieldValidateOf.hasResults()) {
                values[i] = fieldValidateOf.results();
                continue;
            }
            hasAllValues = false;
            errors.add(new ValidationError.NoResultsFoundForNode(nextPath, fieldClass.getClass(), "record decoding"));
        }
        if (!hasAllValues) {
            return ValidateOf.inValid(errors);
        }
        return ValidateOf.validateOf(RecordUtils.invokeCanonicalConstructor(klass, recordComponents, values), errors);
    }
}

