/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.decoder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.github.gestalt.config.decoder.CollectionDecoder;
import org.github.gestalt.config.decoder.DecoderContext;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.reflect.TypeCapture;
import org.github.gestalt.config.tag.Tags;
import org.github.gestalt.config.utils.PathUtil;
import org.github.gestalt.config.utils.ValidateOf;

public final class SetDecoder
extends CollectionDecoder<Set<?>> {
    @Override
    public String name() {
        return "Set";
    }

    @Override
    public boolean matches(TypeCapture<?> type) {
        return Set.class.isAssignableFrom(type.getRawType()) && type.hasParameter();
    }

    @Override
    protected ValidateOf<Set<?>> arrayDecode(String path, Tags tags, ConfigNode node, TypeCapture<?> klass, DecoderContext decoderContext) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        HashSet results = new HashSet(node.size());
        for (int i = 0; i < node.size(); ++i) {
            if (node.getIndex(i).isPresent()) {
                ConfigNode currentNode = node.getIndex(i).get();
                String nextPath = PathUtil.pathForIndex(path, i);
                ValidateOf<?> validateOf = decoderContext.getDecoderService().decodeNode(nextPath, tags, currentNode, klass.getFirstParameterType(), decoderContext);
                errors.addAll(validateOf.getErrors());
                if (!validateOf.hasResults()) continue;
                results.add(validateOf.results());
                continue;
            }
            errors.add(new ValidationError.ArrayMissingIndex(i, path));
        }
        return ValidateOf.validateOf(!results.isEmpty() ? results : null, errors);
    }
}

