/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.entity;

import java.util.Objects;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.source.ConfigSource;
import org.github.gestalt.config.tag.Tags;

public final class ConfigNodeContainer {
    private final ConfigNode configNode;
    private final ConfigSource source;

    public ConfigNodeContainer(ConfigNode configNode, ConfigSource source) {
        this.configNode = configNode;
        this.source = source;
    }

    public ConfigNode getConfigNode() {
        return this.configNode;
    }

    public ConfigSource getSource() {
        return this.source;
    }

    public Tags getTags() {
        return this.source.getTags();
    }

    public boolean matchesTokens(Tags match) {
        return this.source.getTags().equals(match);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigNodeContainer)) {
            return false;
        }
        ConfigNodeContainer that = (ConfigNodeContainer)o;
        return Objects.equals(this.configNode, that.configNode) && Objects.equals(this.source, that.source);
    }

    public int hashCode() {
        return Objects.hash(this.configNode, this.source);
    }
}

