/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.entity;

import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import org.github.gestalt.config.decoder.ProxyDecoderMode;
import org.github.gestalt.config.entity.GestaltModuleConfig;

public class GestaltConfig {
    private final Map<Class, GestaltModuleConfig> modulesConfig = new HashMap<Class, GestaltModuleConfig>();
    private boolean treatWarningsAsErrors = false;
    private boolean treatMissingArrayIndexAsError = false;
    private boolean treatMissingValuesAsErrors = false;
    private boolean treatNullValuesInClassAsErrors = true;
    private ProxyDecoderMode proxyDecoderMode = ProxyDecoderMode.CACHE;
    private System.Logger.Level logLevelForMissingValuesWhenDefaultOrOptional = System.Logger.Level.DEBUG;
    private DateTimeFormatter dateDecoderFormat = DateTimeFormatter.ISO_DATE_TIME;
    private DateTimeFormatter localDateTimeFormat = DateTimeFormatter.ISO_DATE_TIME;
    private DateTimeFormatter localDateFormat = DateTimeFormatter.ISO_DATE_TIME;
    private String substitutionOpeningToken = "${";
    private String substitutionClosingToken = "}";
    private int maxSubstitutionNestedDepth = 5;
    private String substitutionRegex = "^((?<transform>\\w+):(?!=))?(?<key>.+?)(:=(?<default>.*))?$";

    public boolean isTreatWarningsAsErrors() {
        return this.treatWarningsAsErrors;
    }

    public void setTreatWarningsAsErrors(boolean treatWarningsAsErrors) {
        this.treatWarningsAsErrors = treatWarningsAsErrors;
    }

    public boolean isTreatMissingArrayIndexAsError() {
        return this.treatMissingArrayIndexAsError;
    }

    public void setTreatMissingArrayIndexAsError(boolean treatMissingArrayIndexAsError) {
        this.treatMissingArrayIndexAsError = treatMissingArrayIndexAsError;
    }

    public boolean isTreatMissingValuesAsErrors() {
        return this.treatMissingValuesAsErrors;
    }

    public void setTreatMissingValuesAsErrors(boolean treatMissingValuesAsErrors) {
        this.treatMissingValuesAsErrors = treatMissingValuesAsErrors;
    }

    public boolean isTreatNullValuesInClassAsErrors() {
        return this.treatNullValuesInClassAsErrors;
    }

    public void setTreatNullValuesInClassAsErrors(boolean treatNullValuesInClassAsErrors) {
        this.treatNullValuesInClassAsErrors = treatNullValuesInClassAsErrors;
    }

    public ProxyDecoderMode getProxyDecoderMode() {
        return this.proxyDecoderMode;
    }

    public void setProxyDecoderMode(ProxyDecoderMode proxyDecoderMode) {
        this.proxyDecoderMode = proxyDecoderMode;
    }

    public System.Logger.Level getLogLevelForMissingValuesWhenDefaultOrOptional() {
        return this.logLevelForMissingValuesWhenDefaultOrOptional;
    }

    public void setLogLevelForMissingValuesWhenDefaultOrOptional(System.Logger.Level logLevelForMissingValuesWhenDefaultOrOptional) {
        this.logLevelForMissingValuesWhenDefaultOrOptional = logLevelForMissingValuesWhenDefaultOrOptional;
    }

    public DateTimeFormatter getDateDecoderFormat() {
        return this.dateDecoderFormat;
    }

    public void setDateDecoderFormat(DateTimeFormatter dateDecoderFormat) {
        this.dateDecoderFormat = dateDecoderFormat;
    }

    public DateTimeFormatter getLocalDateTimeFormat() {
        return this.localDateTimeFormat;
    }

    public void setLocalDateTimeFormat(DateTimeFormatter localDateTimeFormat) {
        this.localDateTimeFormat = localDateTimeFormat;
    }

    public DateTimeFormatter getLocalDateFormat() {
        return this.localDateFormat;
    }

    public void setLocalDateFormat(DateTimeFormatter localDateFormat) {
        this.localDateFormat = localDateFormat;
    }

    public String getSubstitutionOpeningToken() {
        return this.substitutionOpeningToken;
    }

    public void setSubstitutionOpeningToken(String substitutionOpeningToken) {
        this.substitutionOpeningToken = substitutionOpeningToken;
    }

    public String getSubstitutionClosingToken() {
        return this.substitutionClosingToken;
    }

    public void setSubstitutionClosingToken(String substitutionClosingToken) {
        this.substitutionClosingToken = substitutionClosingToken;
    }

    public int getMaxSubstitutionNestedDepth() {
        return this.maxSubstitutionNestedDepth;
    }

    public void setMaxSubstitutionNestedDepth(int maxSubstitutionNestedDepth) {
        this.maxSubstitutionNestedDepth = maxSubstitutionNestedDepth;
    }

    public String getSubstitutionRegex() {
        return this.substitutionRegex;
    }

    public void setSubstitutionRegex(String substitutionRegex) {
        this.substitutionRegex = substitutionRegex;
    }

    public void registerModuleConfig(GestaltModuleConfig module) {
        this.modulesConfig.put(module.getClass(), module);
    }

    public void registerModuleConfig(Map<Class, GestaltModuleConfig> module) {
        this.modulesConfig.putAll(module);
    }

    public <T extends GestaltModuleConfig> T getModuleConfig(Class<T> klass) {
        return (T)this.modulesConfig.get(klass);
    }
}

