/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.lexer;

import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.lexer.SentenceLexer;
import org.github.gestalt.config.token.ArrayToken;
import org.github.gestalt.config.token.ObjectToken;
import org.github.gestalt.config.token.Token;
import org.github.gestalt.config.utils.StringUtils;
import org.github.gestalt.config.utils.ValidateOf;

public final class PathLexer
extends SentenceLexer {
    public static final String DEFAULT_EVALUATOR = "^((?<name>[\\w .,+=\\-;:\"'`~!@#$%^&*()\\<>]+)(?<array>\\[(?<index>\\d*)])?)$";
    public static final String DELIMITER = ".";
    private final Pattern pathPattern;
    private final String delimiter;
    private final String delimiterRegex;

    public PathLexer() {
        this.pathPattern = Pattern.compile(DEFAULT_EVALUATOR, 2);
        this.delimiter = DELIMITER;
        this.delimiterRegex = Pattern.quote(DELIMITER);
    }

    public PathLexer(String delimiter) {
        this.pathPattern = Pattern.compile(DEFAULT_EVALUATOR, 2);
        this.delimiter = delimiter;
        this.delimiterRegex = Pattern.quote(delimiter);
    }

    public PathLexer(String delimiter, String pathPatternRegex) {
        this.pathPattern = Pattern.compile(pathPatternRegex, 2);
        this.delimiter = delimiter;
        this.delimiterRegex = Pattern.quote(delimiter);
    }

    @Override
    public String getDeliminator() {
        return this.delimiter;
    }

    @Override
    protected List<String> tokenizer(String sentence) {
        return sentence != null && !sentence.isEmpty() ? List.of(sentence.split(this.delimiterRegex)) : Collections.emptyList();
    }

    @Override
    protected ValidateOf<List<Token>> evaluator(String word, String sentence) {
        ValidateOf<List<Token>> results;
        if (sentence == null || sentence.isEmpty()) {
            return ValidateOf.inValid(new ValidationError.EmptyPath());
        }
        if (word == null || word.isEmpty()) {
            return ValidateOf.inValid(new ValidationError.EmptyElement(sentence));
        }
        Matcher matcher = this.pathPattern.matcher(word);
        if (!matcher.find()) {
            return ValidateOf.inValid(new ValidationError.FailedToTokenizeElement(word, sentence));
        }
        String name = matcher.group("name");
        if (name == null || name.isEmpty()) {
            return ValidateOf.inValid(new ValidationError.UnableToParseName(sentence));
        }
        String array = matcher.group("array");
        String arrayIndex = matcher.group("index");
        if (array != null && arrayIndex != null && !arrayIndex.isEmpty()) {
            int index;
            results = StringUtils.isInteger(arrayIndex) ? ((index = Integer.parseInt(arrayIndex)) >= 0 ? ValidateOf.valid(List.of(new ObjectToken(name), new ArrayToken(index))) : ValidateOf.inValid(new ValidationError.InvalidArrayNegativeIndexToken(word, index, sentence))) : ValidateOf.inValid(new ValidationError.InvalidArrayToken(word, arrayIndex, sentence));
        } else if (array != null) {
            results = ValidateOf.inValid(new ValidationError.InvalidArrayIndexToken(word, sentence));
        } else {
            ObjectToken object = new ObjectToken(name);
            List<ObjectToken> list = Collections.singletonList(object);
            results = ValidateOf.valid(list);
        }
        return results;
    }
}

