/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.lexer;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.token.Token;
import org.github.gestalt.config.utils.ValidateOf;

public abstract class SentenceLexer {
    public abstract String getDeliminator();

    protected abstract List<String> tokenizer(String var1);

    protected abstract ValidateOf<List<Token>> evaluator(String var1, String var2);

    public String normalizeSentence(String sentence) {
        return sentence.toLowerCase(Locale.getDefault());
    }

    public ValidateOf<List<Token>> scan(String sentence) {
        if (sentence == null || sentence.isEmpty()) {
            return ValidateOf.inValid(new ValidationError.EmptyPath());
        }
        String normalizedSentence = this.normalizeSentence(sentence);
        List<String> tokenList = this.tokenizer(normalizedSentence);
        List tokenWithValidations = tokenList.stream().map(word -> this.evaluator((String)word, normalizedSentence)).collect(Collectors.toList());
        List tokens = tokenWithValidations.stream().filter(ValidateOf::hasResults).map(ValidateOf::results).flatMap(Collection::stream).collect(Collectors.toList());
        List<ValidationError> validations = tokenWithValidations.stream().filter(ValidateOf::hasErrors).map(ValidateOf::getErrors).flatMap(Collection::stream).collect(Collectors.toList());
        return ValidateOf.validateOf(tokens, validations);
    }
}

