/*
 * Decompiled with CFR 0.152.
 */
package org.github.gestalt.config.loader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.github.gestalt.config.entity.ConfigValue;
import org.github.gestalt.config.entity.ValidationError;
import org.github.gestalt.config.entity.ValidationLevel;
import org.github.gestalt.config.lexer.SentenceLexer;
import org.github.gestalt.config.node.ConfigNode;
import org.github.gestalt.config.parser.ConfigParser;
import org.github.gestalt.config.token.Token;
import org.github.gestalt.config.utils.Pair;
import org.github.gestalt.config.utils.ValidateOf;

public final class ConfigCompiler {
    private ConfigCompiler() {
    }

    public static ValidateOf<ConfigNode> analyze(boolean failOnErrors, SentenceLexer lexer, ConfigParser parser, List<Pair<String, String>> configs) {
        ArrayList<ValidationError> errorMessage = new ArrayList();
        List validatedTokens = configs.stream().map(prop -> new Pair<ValidateOf<List<Token>>, String>(lexer.scan((String)prop.getFirst()), (String)prop.getSecond())).collect(Collectors.toList());
        Map<ValidationLevel, List<ValidationError>> validationErrors = validatedTokens.stream().filter(validatedToken -> ((ValidateOf)validatedToken.getFirst()).hasErrors()).map(validatedToken -> ((ValidateOf)validatedToken.getFirst()).getErrors()).flatMap(Collection::stream).collect(Collectors.groupingBy(ValidationError::level));
        if (!validationErrors.isEmpty()) {
            errorMessage = validationErrors.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            if (failOnErrors && validationErrors.containsKey((Object)ValidationLevel.ERROR)) {
                return ValidateOf.inValid(errorMessage);
            }
        }
        List<Pair<List<Token>, ConfigValue>> validTokens = validatedTokens.stream().filter(validatedToken -> ((ValidateOf)validatedToken.getFirst()).hasErrors() == false && ((ValidateOf)validatedToken.getFirst()).hasResults() && !((List)((ValidateOf)validatedToken.getFirst()).results()).isEmpty()).map(validatedToken -> new Pair<List, ConfigValue>((List)((ValidateOf)validatedToken.getFirst()).results(), new ConfigValue((String)validatedToken.getSecond()))).collect(Collectors.toList());
        ValidateOf<ConfigNode> parserResults = parser.parse(validTokens, failOnErrors);
        errorMessage.addAll(parserResults.getErrors());
        return ValidateOf.validateOf(parserResults.results(), errorMessage);
    }
}

